/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.terraform.shapes.api;

import com.terraformersmc.terraform.shapes.api.Quaternion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;

public interface Position {
    public double getX();

    public double getY();

    public double getZ();

    public void setX(double var1);

    public void setY(double var1);

    public void setZ(double var1);

    public Position move(double var1, double var3, double var5);

    public static Position of(final double ofX, final double ofY, final double ofZ) {
        return new Position(){
            private double x;
            private double y;
            private double z;
            {
                this.x = ofX;
                this.y = ofY;
                this.z = ofZ;
            }

            @Override
            public double getX() {
                return this.x;
            }

            @Override
            public double getY() {
                return this.y;
            }

            @Override
            public double getZ() {
                return this.z;
            }

            @Override
            public void setX(double d) {
                this.x = d;
            }

            @Override
            public void setY(double d) {
                this.y = d;
            }

            @Override
            public void setZ(double d) {
                this.z = d;
            }

            @Override
            public Position move(double x, double y, double z) {
                return Position.of(this.x + x, this.y + y, this.z + z);
            }
        };
    }

    public static Position of(Position pos) {
        return Position.of(pos.getX(), pos.getY(), pos.getZ());
    }

    default public Position copy() {
        return Position.of(this);
    }

    public static Position of(BlockPos pos) {
        return Position.of(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    default public BlockPos toBlockPos() {
        return new BlockPos(this.getX(), this.getY(), this.getZ());
    }

    public static Stream<Position> stream(Position start, Position end) {
        ArrayList stream = new ArrayList();
        IntStream.range((int)Math.floor(Double.min(start.getX(), end.getX())), (int)Math.ceil(Double.max(start.getX(), end.getX()))).forEach(x -> IntStream.range((int)Math.floor(Double.min(start.getY(), end.getY())), (int)Math.ceil(Double.max(start.getY(), end.getY()))).forEach(y -> IntStream.range((int)Math.floor(Double.min(start.getZ(), end.getZ())), (int)Math.ceil(Double.max(start.getZ(), end.getZ()))).forEach(z -> stream.add(Position.of(x, y, z)))));
        return stream.stream();
    }

    public static List<Position> vertices(Position start, Position end) {
        return Arrays.asList(Position.of(start.getX(), start.getY(), start.getZ()), Position.of(start.getX(), start.getY(), end.getZ()), Position.of(start.getX(), end.getY(), start.getZ()), Position.of(start.getX(), end.getY(), end.getZ()), Position.of(end.getX(), start.getY(), start.getZ()), Position.of(end.getX(), end.getY(), start.getZ()), Position.of(end.getX(), end.getY(), end.getZ()), Position.of(end.getX(), start.getY(), end.getZ()));
    }

    public static Position of(Quaternion q) {
        return Position.of(q.getI(), q.getJ(), q.getK());
    }

    default public Quaternion toQuaternion() {
        return Quaternion.of(0.0, this.getX(), this.getY(), this.getZ());
    }

    default public Position rotateBy(Quaternion q) {
        Quaternion newQuat = q.copy();
        Quaternion conjugate = q.conjugate();
        return newQuat.multiply(this.toQuaternion()).multiply(conjugate).toPosition();
    }
}

