/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.terraform.wood.block;

import com.terraformersmc.terraform.wood.block.BareSmallLogBlock;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SmallLogBlock
extends BareSmallLogBlock {
    public static final BooleanProperty HAS_LEAVES = BooleanProperty.m_61465_((String)"has_leaves");
    private static final int UP_MASK = 1 << Direction.UP.ordinal();
    private static final int DOWN_MASK = 1 << Direction.DOWN.ordinal();
    private static final int NORTH_MASK = 1 << Direction.NORTH.ordinal();
    private static final int EAST_MASK = 1 << Direction.EAST.ordinal();
    private static final int SOUTH_MASK = 1 << Direction.SOUTH.ordinal();
    private static final int WEST_MASK = 1 << Direction.WEST.ordinal();
    protected final VoxelShape[] collisionShapes;
    protected final VoxelShape[] boundingShapes;
    private final Object2IntMap<BlockState> SHAPE_INDEX_CACHE = new Object2IntOpenHashMap();
    private final Block leaves;
    private final Supplier<Block> stripped;

    public SmallLogBlock(Block leaves, Supplier<Block> stripped, BlockBehaviour.Properties settings) {
        super(stripped, settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_LEAVES, (Comparable)Boolean.valueOf(false)));
        this.collisionShapes = this.createShapes(5.0);
        this.boundingShapes = this.createShapes(5.0);
        this.leaves = leaves;
        this.stripped = stripped;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState state, Level world, BlockPos pos, Random random) {
        if (((Boolean)state.m_61143_((Property)HAS_LEAVES)).booleanValue()) {
            Blocks.f_50050_.m_7100_(state, world, pos, random);
        }
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        DiggerItem tool;
        ItemStack held = player.m_21120_(hand);
        if (held.m_41613_() >= 1 && held.m_41720_() == Item.f_41373_.get(this.leaves) && !((Boolean)state.m_61143_((Property)HAS_LEAVES)).booleanValue()) {
            if (!player.m_7500_()) {
                held.m_41774_(1);
            }
            SoundType sounds = this.leaves.m_49966_().m_60827_();
            world.m_5594_(player, pos, sounds.m_56777_(), SoundSource.BLOCKS, (sounds.m_56773_() + 1.0f) / 2.0f, sounds.m_56774_() * 0.8f);
            BlockState previous = state;
            state = (BlockState)state.m_61124_((Property)HAS_LEAVES, (Comparable)Boolean.valueOf(true));
            if (((Boolean)state.m_61143_((Property)UP)).booleanValue() && world.m_8055_(pos.m_7494_()).m_60734_() instanceof LeavesBlock) {
                state = (BlockState)state.m_61124_((Property)UP, (Comparable)Boolean.valueOf(false));
            }
            if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue() && world.m_8055_(pos.m_7495_()).m_60734_() instanceof LeavesBlock) {
                state = (BlockState)state.m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false));
            }
            if (((Boolean)state.m_61143_((Property)WEST)).booleanValue() && world.m_8055_(pos.m_142125_()).m_60734_() instanceof LeavesBlock) {
                state = (BlockState)state.m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false));
            }
            if (((Boolean)state.m_61143_((Property)EAST)).booleanValue() && world.m_8055_(pos.m_142126_()).m_60734_() instanceof LeavesBlock) {
                state = (BlockState)state.m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false));
            }
            if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue() && world.m_8055_(pos.m_142127_()).m_60734_() instanceof LeavesBlock) {
                state = (BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false));
            }
            if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue() && world.m_8055_(pos.m_142128_()).m_60734_() instanceof LeavesBlock) {
                state = (BlockState)state.m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false));
            }
            world.m_46597_(pos, SmallLogBlock.m_49897_((BlockState)previous, (BlockState)state, (Level)world, (BlockPos)pos));
            return InteractionResult.SUCCESS;
        }
        if (this.stripped != null && held.m_41720_() instanceof DiggerItem && (tool = (DiggerItem)held.m_41720_()).m_8102_(held, state) > 1.0f) {
            world.m_5594_(player, pos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!world.f_46443_) {
                BlockState target = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stripped.get().m_49966_().m_61124_((Property)BareSmallLogBlock.UP, (Comparable)((Boolean)state.m_61143_((Property)BareSmallLogBlock.UP)))).m_61124_((Property)BareSmallLogBlock.DOWN, (Comparable)((Boolean)state.m_61143_((Property)BareSmallLogBlock.DOWN)))).m_61124_((Property)BareSmallLogBlock.NORTH, (Comparable)((Boolean)state.m_61143_((Property)BareSmallLogBlock.NORTH)))).m_61124_((Property)BareSmallLogBlock.SOUTH, (Comparable)((Boolean)state.m_61143_((Property)BareSmallLogBlock.SOUTH)))).m_61124_((Property)BareSmallLogBlock.EAST, (Comparable)((Boolean)state.m_61143_((Property)BareSmallLogBlock.EAST)))).m_61124_((Property)BareSmallLogBlock.WEST, (Comparable)((Boolean)state.m_61143_((Property)BareSmallLogBlock.WEST)))).m_61124_((Property)BareSmallLogBlock.WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)BareSmallLogBlock.WATERLOGGED)))).m_61124_((Property)HAS_LEAVES, (Comparable)((Boolean)state.m_61143_((Property)HAS_LEAVES)));
                world.m_46597_(pos, target);
                held.m_41622_(1, (LivingEntity)player, consumedPlayer -> consumedPlayer.m_21190_(hand));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HAS_LEAVES});
    }

    private boolean shouldConnectTo(BlockState state, boolean solid, boolean leaves) {
        Block block = state.m_60734_();
        return solid || !leaves && block instanceof LeavesBlock || block instanceof BareSmallLogBlock;
    }

    @Override
    public BlockState getNeighborUpdateState(BlockState state, Direction fromDirection, BlockState neighbor, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        boolean leaves = (Boolean)state.m_61143_((Property)HAS_LEAVES);
        boolean up = fromDirection == Direction.UP && this.shouldConnectTo(neighbor, neighbor.m_60783_((BlockGetter)world, neighborPos, Direction.DOWN), leaves) || (Boolean)state.m_61143_((Property)UP) != false;
        boolean down = fromDirection == Direction.DOWN && this.shouldConnectTo(neighbor, neighbor.m_60783_((BlockGetter)world, neighborPos, Direction.UP), leaves) || (Boolean)state.m_61143_((Property)DOWN) != false;
        boolean north = fromDirection == Direction.NORTH && this.shouldConnectTo(neighbor, neighbor.m_60783_((BlockGetter)world, neighborPos, Direction.SOUTH), leaves) || (Boolean)state.m_61143_((Property)NORTH) != false;
        boolean east = fromDirection == Direction.EAST && this.shouldConnectTo(neighbor, neighbor.m_60783_((BlockGetter)world, neighborPos, Direction.WEST), leaves) || (Boolean)state.m_61143_((Property)EAST) != false;
        boolean south = fromDirection == Direction.SOUTH && this.shouldConnectTo(neighbor, neighbor.m_60783_((BlockGetter)world, neighborPos, Direction.NORTH), leaves) || (Boolean)state.m_61143_((Property)SOUTH) != false;
        boolean west = fromDirection == Direction.WEST && this.shouldConnectTo(neighbor, neighbor.m_60783_((BlockGetter)world, neighborPos, Direction.EAST), leaves) || (Boolean)state.m_61143_((Property)WEST) != false;
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)UP, (Comparable)Boolean.valueOf(up))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(down))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(north))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(east))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(south))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(west));
    }

    private int getShapeIndex(BlockState requested) {
        return this.SHAPE_INDEX_CACHE.computeIntIfAbsent((Object)requested, state -> {
            int mask = 0;
            if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
                mask |= UP_MASK;
            }
            if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
                mask |= DOWN_MASK;
            }
            if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
                mask |= NORTH_MASK;
            }
            if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
                mask |= EAST_MASK;
            }
            if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
                mask |= SOUTH_MASK;
            }
            if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
                mask |= WEST_MASK;
            }
            return mask;
        });
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)HAS_LEAVES) != false ? Shapes.m_83144_() : this.boundingShapes[this.getShapeIndex(state)];
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)HAS_LEAVES) != false ? Shapes.m_83144_() : this.collisionShapes[this.getShapeIndex(state)];
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter world, BlockPos pos) {
        return this.collisionShapes[this.getShapeIndex(state)];
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.collisionShapes[this.getShapeIndex(state)];
    }
}

