/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.terraform.wood.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class QuarterLogBlock
extends RotatedPillarBlock {
    public static final EnumProperty<BarkSide> BARK_SIDE = EnumProperty.m_61587_((String)"bark_side", BarkSide.class);
    private final Supplier<Block> stripped;

    public QuarterLogBlock(Supplier<Block> stripped, MaterialColor color, BlockBehaviour.Properties settings) {
        super(settings);
        this.stripped = stripped;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BARK_SIDE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Vec3 pos = context.m_43720_();
        BlockPos blockPos = context.m_8083_();
        float hitX = (float)(pos.m_7096_() - (double)blockPos.m_123341_());
        float hitY = (float)(pos.m_7098_() - (double)blockPos.m_123342_());
        float hitZ = (float)(pos.m_7094_() - (double)blockPos.m_123343_());
        BarkSide side = BarkSide.fromHit(context.m_43719_().m_122434_(), hitX, hitY, hitZ);
        return (BlockState)super.m_5573_(context).m_61124_(BARK_SIDE, (Comparable)((Object)side));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldStack = player.m_6844_(hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
        if (heldStack.m_41619_()) {
            return InteractionResult.FAIL;
        }
        Item held = heldStack.m_41720_();
        if (!(held instanceof DiggerItem)) {
            return InteractionResult.FAIL;
        }
        DiggerItem tool = (DiggerItem)held;
        if (this.stripped != null && tool.m_8102_(heldStack, state) > 1.0f) {
            world.m_5594_(player, pos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!world.f_46443_) {
                BlockState target = (BlockState)((BlockState)this.stripped.get().m_49966_().m_61124_((Property)f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)f_55923_)))).m_61124_(BARK_SIDE, (Comparable)((Object)((BarkSide)((Object)state.m_61143_(BARK_SIDE)))));
                world.m_46597_(pos, target);
                heldStack.m_41622_(1, (LivingEntity)player, consumedPlayer -> consumedPlayer.m_21190_(hand));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public static enum BarkSide implements StringRepresentable
    {
        SOUTHWEST("southwest"),
        NORTHWEST("northwest"),
        NORTHEAST("northeast"),
        SOUTHEAST("southeast");

        final String name;

        private BarkSide(String name) {
            this.name = name;
        }

        public static BarkSide fromHit(Direction.Axis axis, float hitX, float hitY, float hitZ) {
            boolean hitEast;
            return BarkSide.fromHalves(!hitEast, !(switch (axis) {
                case Direction.Axis.Y -> {
                    hitEast = (double)hitX >= 0.5;
                    yield (double)hitZ >= 0.5;
                }
                case Direction.Axis.X -> {
                    hitEast = (double)hitY <= 0.5;
                    yield (double)hitZ >= 0.5;
                }
                default -> {
                    hitEast = (double)hitX >= 0.5;
                    yield (double)hitY >= 0.5;
                }
            }));
        }

        public static BarkSide fromHalves(boolean east, boolean south) {
            if (east) {
                if (south) {
                    return SOUTHEAST;
                }
                return NORTHEAST;
            }
            if (south) {
                return SOUTHWEST;
            }
            return NORTHWEST;
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

