/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.terraform.leaves.block;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class ExtendedLeavesBlock
extends Block
implements IForgeShearable {
    public static final int MAX_DISTANCE = 14;
    public static final BooleanProperty PERSISTENT = BlockStateProperties.f_61447_;
    public static final IntegerProperty DISTANCE = IntegerProperty.m_61631_((String)"distance", (int)1, (int)14);

    public ExtendedLeavesBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(14))).m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)DISTANCE) == 14 && (Boolean)state.m_61143_((Property)PERSISTENT) == false;
    }

    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        if (!((Boolean)state.m_61143_((Property)PERSISTENT)).booleanValue() && (Integer)state.m_61143_((Property)DISTANCE) == 14) {
            ExtendedLeavesBlock.m_49950_((BlockState)state, (Level)world, (BlockPos)pos);
            world.m_7471_(pos, false);
        }
    }

    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        world.m_7731_(pos, ExtendedLeavesBlock.updateDistanceFromLogs(state, (LevelAccessor)world, pos), 3);
    }

    public int m_7753_(BlockState state, BlockGetter view, BlockPos pos) {
        return 0;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        int distance = ExtendedLeavesBlock.getDistanceFromLog(neighborState) + 1;
        if (distance != 1 || (Integer)state.m_61143_((Property)DISTANCE) != distance) {
            world.m_186460_(pos, (Block)this, 1);
        }
        return state;
    }

    private static BlockState updateDistanceFromLogs(BlockState state, LevelAccessor world, BlockPos pos) {
        int distance = 14;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            mutable.m_122159_((Vec3i)pos, direction);
            distance = Math.min(distance, ExtendedLeavesBlock.getDistanceFromLog(world.m_8055_((BlockPos)mutable)) + 1);
            if (distance == 1) break;
        }
        return (BlockState)state.m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(distance));
    }

    private static int getDistanceFromLog(BlockState state) {
        if (state.m_204336_(BlockTags.f_13106_)) {
            return 0;
        }
        return state.m_60734_() instanceof ExtendedLeavesBlock ? (Integer)state.m_61143_((Property)DISTANCE) : 14;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState state, Level world, BlockPos pos, Random random) {
        Blocks.f_50050_.m_7100_(state, world, pos, random);
    }

    public boolean m_6104_(BlockState state, BlockState neighborState, Direction offset) {
        return neighborState.m_60734_() instanceof ExtendedLeavesBlock;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DISTANCE, PERSISTENT});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return ExtendedLeavesBlock.updateDistanceFromLogs((BlockState)this.m_49966_().m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)), (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter world, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        ItemStack stack;
        List list = super.m_7381_(state, builder);
        if (ModList.get().isLoaded("antimatter") && (stack = (ItemStack)builder.m_78970_(LootContextParams.f_81463_)) != null && !stack.m_41619_() && stack.m_41720_().getRegistryName().toString().equals("antimatter:branch_cutter")) {
            ItemStack sapling = ItemStack.f_41583_;
            if (ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(this.getRegistryName().toString().replace("leaves", "sapling")))) {
                sapling = new ItemStack((ItemLike)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(this.getRegistryName().toString().replace("leaves", "sapling"))));
            }
            if (!sapling.m_41619_()) {
                list.clear();
                list.add(sapling);
            }
        }
        return list;
    }
}

