/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.terraform.boat.impl.item;

import com.terraformersmc.terraform.boat.api.TerraformBoatType;
import com.terraformersmc.terraform.boat.impl.TerraformBoatEntity;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TerraformBoatItem
extends Item {
    private static final Predicate<Entity> RIDERS = EntitySelector.f_20408_.and(Entity::m_6087_);
    private final Supplier<TerraformBoatType> boatSupplier;

    public TerraformBoatItem(Supplier<TerraformBoatType> boatSupplier, Item.Properties settings) {
        super(settings);
        this.boatSupplier = boatSupplier;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.m_21120_(hand);
        BlockHitResult hitResult = Item.m_41435_((Level)world, (Player)user, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitResult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        Vec3 rotationVec = user.m_20252_(1.0f);
        List riders = world.m_6249_((Entity)user, user.m_142469_().m_82369_(rotationVec.m_82490_(5.0)).m_82400_(1.0), RIDERS);
        if (!riders.isEmpty()) {
            Vec3 eyePos = user.m_146892_();
            for (Entity entity : riders) {
                AABB box = entity.m_142469_().m_82400_((double)entity.m_6143_());
                if (!box.m_82390_(eyePos)) continue;
                return InteractionResultHolder.m_19098_((Object)stack);
            }
        }
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            TerraformBoatEntity boatEntity = new TerraformBoatEntity(world, hitResult.m_82450_().f_82479_, hitResult.m_82450_().f_82480_, hitResult.m_82450_().f_82481_);
            boatEntity.setTerraformBoat(this.boatSupplier.get());
            boatEntity.m_146922_(user.m_146908_());
            if (!world.m_45756_((Entity)boatEntity, boatEntity.m_142469_().m_82400_(-0.1))) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            if (!world.m_5776_()) {
                world.m_7967_((Entity)boatEntity);
                world.m_142346_((Entity)user, GameEvent.f_157810_, new BlockPos(hitResult.m_82450_()));
                if (!user.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            }
            user.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }
}

