/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.terraform.boat.impl.client;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.terraformersmc.terraform.boat.api.TerraformBoatType;
import com.terraformersmc.terraform.boat.api.TerraformBoatTypeRegistry;
import com.terraformersmc.terraform.boat.api.client.TerraformBoatClientHelper;
import com.terraformersmc.terraform.boat.impl.TerraformBoatEntity;
import java.util.Map;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TerraformBoatEntityRenderer
extends BoatRenderer {
    private final Map<TerraformBoatType, Pair<ResourceLocation, BoatModel>> texturesAndModels = (Map)TerraformBoatTypeRegistry.INSTANCE.m_6579_().stream().collect(ImmutableMap.toImmutableMap(entry -> (TerraformBoatType)entry.getValue(), entry -> {
        ResourceLocation id = ((ResourceKey)entry.getKey()).m_135782_();
        ResourceLocation textureId = new ResourceLocation(id.m_135827_(), "textures/entity/boat/" + id.m_135815_() + ".png");
        ModelLayerLocation layer = TerraformBoatClientHelper.getLayer(id);
        BoatModel model = new BoatModel(context.m_174023_(layer));
        return new Pair((Object)textureId, (Object)model);
    }));

    public TerraformBoatEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public ResourceLocation m_5478_(Boat entity) {
        if (entity instanceof TerraformBoatEntity) {
            TerraformBoatType boat = ((TerraformBoatEntity)entity).getTerraformBoat();
            return (ResourceLocation)this.texturesAndModels.get(boat).getFirst();
        }
        return super.m_5478_(entity);
    }

    public Pair<ResourceLocation, BoatModel> getModelWithLocation(Boat boat) {
        if (boat instanceof TerraformBoatEntity) {
            TerraformBoatEntity boatEntity = (TerraformBoatEntity)boat;
            return this.getTextureAndModel(boatEntity);
        }
        return super.getModelWithLocation(boat);
    }

    public Pair<ResourceLocation, BoatModel> getTextureAndModel(TerraformBoatEntity entity) {
        return this.texturesAndModels.get(entity.getTerraformBoat());
    }
}

