/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.terraform.boat.impl;

import com.terraformersmc.terraform.boat.api.TerraformBoatType;
import com.terraformersmc.terraform.boat.api.TerraformBoatTypeRegistry;
import com.terraformersmc.terraform.boat.impl.TerraformBoatInitializer;
import com.terraformersmc.terraform.boat.impl.TerraformBoatTrackedData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class TerraformBoatEntity
extends Boat {
    private static final String BOAT_KEY = "TerraformBoat";
    private static final EntityDataAccessor<TerraformBoatType> TERRAFORM_BOAT = SynchedEntityData.m_135353_(TerraformBoatEntity.class, TerraformBoatTrackedData.HANDLER);

    public TerraformBoatEntity(EntityType<TerraformBoatEntity> type, Level world) {
        super(type, world);
    }

    public TerraformBoatEntity(Level world) {
        this(TerraformBoatInitializer.BOAT, world);
    }

    public TerraformBoatEntity(Level world, double x, double y, double z) {
        this(TerraformBoatInitializer.BOAT, world);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public TerraformBoatType getTerraformBoat() {
        return (TerraformBoatType)this.f_19804_.m_135370_(TERRAFORM_BOAT);
    }

    public void setTerraformBoat(TerraformBoatType boat) {
        this.f_19804_.m_135381_(TERRAFORM_BOAT, (Object)boat);
    }

    private boolean hasValidTerraformBoat() {
        return this.getTerraformBoat() != null;
    }

    public Item m_38369_() {
        return this.getTerraformBoat().item();
    }

    public boolean m_6000_(double cameraX, double cameraY, double cameraZ) {
        return this.hasValidTerraformBoat() && super.m_6000_(cameraX, cameraY, cameraZ);
    }

    public void m_8119_() {
        if (this.hasValidTerraformBoat()) {
            super.m_8119_();
        } else {
            this.m_146870_();
        }
    }

    public void m_38332_(Boat.Type type) {
    }

    public Boat.Type m_38387_() {
        return Boat.Type.OAK;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TERRAFORM_BOAT, null);
    }

    protected void m_7378_(CompoundTag nbt) {
        TerraformBoatType boat;
        super.m_7378_(nbt);
        ResourceLocation id = ResourceLocation.m_135820_((String)nbt.m_128461_(BOAT_KEY));
        if (id != null && (boat = (TerraformBoatType)TerraformBoatTypeRegistry.INSTANCE.m_7745_(id)) != null) {
            this.setTerraformBoat(boat);
        }
        if (!this.hasValidTerraformBoat()) {
            this.m_146870_();
        }
    }

    protected void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        ResourceLocation boatId = TerraformBoatTypeRegistry.INSTANCE.m_7981_((Object)this.getTerraformBoat());
        if (boatId != null) {
            nbt.m_128359_(BOAT_KEY, boatId.toString());
        }
    }
}

