/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.terraform.boat.api.item;

import com.terraformersmc.terraform.boat.api.TerraformBoatType;
import com.terraformersmc.terraform.boat.impl.item.TerraformBoatDispenserBehavior;
import com.terraformersmc.terraform.boat.impl.item.TerraformBoatItem;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;

public final class TerraformBoatItemHelper {
    public static final Map<ResourceLocation, Item> REGISTRY_MAP = new Object2ObjectLinkedOpenHashMap();
    private static final CreativeModeTab DEFAULT_ITEM_GROUP = CreativeModeTab.f_40752_;

    private TerraformBoatItemHelper() {
    }

    public static Item registerBoatItem(ResourceLocation id, Supplier<TerraformBoatType> boatSupplier) {
        return TerraformBoatItemHelper.registerBoatItem(id, boatSupplier, DEFAULT_ITEM_GROUP);
    }

    public static Item registerBoatItem(ResourceLocation id, Supplier<TerraformBoatType> boatSupplier, CreativeModeTab group) {
        return TerraformBoatItemHelper.registerBoatItem(id, boatSupplier, new Item.Properties().m_41487_(1).m_41491_(group));
    }

    public static Item registerBoatItem(ResourceLocation id, Supplier<TerraformBoatType> boatSupplier, Item.Properties settings) {
        TerraformBoatItem item = new TerraformBoatItem(boatSupplier, settings);
        REGISTRY_MAP.put(id, item);
        TerraformBoatItemHelper.registerBoatDispenserBehavior((ItemLike)item, boatSupplier);
        return item;
    }

    public static void registerBoatDispenserBehavior(ItemLike item, Supplier<TerraformBoatType> boatSupplier) {
        DispenserBlock.m_52672_((ItemLike)item, (DispenseItemBehavior)new TerraformBoatDispenserBehavior(boatSupplier));
    }
}

