/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.rsinsertexportupgrade.screen;

import com.refinedmods.refinedstorage.container.slot.filter.FilterSlot;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.ultramega.rsinsertexportupgrade.RSInsertExportUpgrade;
import com.ultramega.rsinsertexportupgrade.container.UpgradeContainerMenu;
import com.ultramega.rsinsertexportupgrade.container.UpgradePlayerSlot;
import com.ultramega.rsinsertexportupgrade.item.UpgradeItem;
import com.ultramega.rsinsertexportupgrade.network.LockSlotUpdateMessage;
import com.ultramega.rsinsertexportupgrade.network.UpgradeUpdateMessage;
import com.ultramega.rsinsertexportupgrade.util.UpgradeType;
import java.awt.Color;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class UpgradeScreen
extends BaseScreen<UpgradeContainerMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("rsinsertexportupgrade", "textures/gui/upgrade.png");
    private static final ResourceLocation CHECKMARK = new ResourceLocation("rsinsertexportupgrade", "textures/gui/checkmark.png");
    private static final ResourceLocation XMARK = new ResourceLocation("rsinsertexportupgrade", "textures/gui/xmark.png");
    private final UpgradeType type;
    private Button modeButton;
    private final int[] selectedInventorySlots;
    private int compare;
    private int mode;
    private boolean cancel = false;
    private boolean dragging = false;
    private int clickedSlotId = -1;
    private int timeSinceRendered = 0;

    public UpgradeScreen(UpgradeType type, UpgradeContainerMenu containerMenu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)containerMenu, type == UpgradeType.EXPORT ? 210 : 176, 163, inventory, title);
        this.type = type;
        this.compare = UpgradeItem.getCompare(containerMenu.getUpgradeItem());
        this.mode = UpgradeItem.getMode(containerMenu.getUpgradeItem());
        this.selectedInventorySlots = UpgradeItem.getSelectedInventorySlots(containerMenu.getUpgradeItem());
    }

    public void onPostInit(int x, int y) {
        this.addCheckBox(x + (this.type == UpgradeType.EXPORT ? 135 : 80), y + 63, (Component)Component.m_237115_((String)"gui.refinedstorage.filter.compare_nbt"), (this.compare & 1) == 1, btn -> {
            this.compare ^= 1;
            this.sendUpdate();
        });
        if (this.type == UpgradeType.INSERT) {
            this.modeButton = this.addButton(x + 118, y + 58, 0, 20, (Component)Component.m_237113_((String)""), true, true, btn -> {
                this.mode = this.mode == 0 ? 1 : 0;
                this.updateModeButton(x, this.mode);
                this.sendUpdate();
            });
            this.updateModeButton(x, this.mode);
        }
    }

    private void updateModeButton(int x, int mode) {
        MutableComponent text = mode == 0 ? Component.m_237115_((String)"sidebutton.refinedstorage.mode.whitelist") : Component.m_237115_((String)"sidebutton.refinedstorage.mode.blacklist");
        this.modeButton.m_93674_(this.f_96547_.m_92895_(text.getString()) + 12);
        this.modeButton.m_252865_(x + 118 - (mode == 1 ? 2 : 0));
        this.modeButton.m_93666_((Component)text);
    }

    public void tick(int x, int y) {
    }

    public void renderBackground(GuiGraphics graphics, int x, int y, int mouseX, int mouseY) {
        if (this.timeSinceRendered < 20) {
            ++this.timeSinceRendered;
        }
        graphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        for (int i = 0; i < ((UpgradeContainerMenu)this.f_97732_).f_38839_.size(); ++i) {
            Slot slot = (Slot)((UpgradeContainerMenu)this.f_97732_).f_38839_.get(i);
            int index = i - 18 - (this.type == UpgradeType.EXPORT ? 2 : 0);
            if (slot instanceof FilterSlot) {
                if (this.type == UpgradeType.INSERT) continue;
                UpgradeScreen.renderSlotHighlight(graphics, this.type, this.f_96547_, slot.f_40220_ + this.f_97735_, slot.f_40221_ + this.f_97736_, true, i - 2 + 1);
                continue;
            }
            if (i < 18 || this.selectedInventorySlots.length <= index) continue;
            if (this.selectedInventorySlots[index] >= 1) {
                UpgradeScreen.renderSlotHighlight(graphics, this.type, this.f_96547_, slot.f_40220_ + this.f_97735_, slot.f_40221_ + this.f_97736_, true, this.selectedInventorySlots[index]);
                continue;
            }
            if (this.selectedInventorySlots[index] != 0) continue;
            UpgradeScreen.renderSlotHighlight(graphics, this.type, this.f_96547_, slot.f_40220_ + this.f_97735_, slot.f_40221_ + this.f_97736_, false, -1);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Slot slot;
        ItemStack itemstack;
        ItemStack itemStack = itemstack = this.f_97711_.m_41619_() ? ((UpgradeContainerMenu)this.f_97732_).m_142621_() : this.f_97711_;
        if (itemstack.m_41619_() && (slot = this.m_97744_(mouseX, mouseY)) instanceof UpgradePlayerSlot) {
            if (UpgradeScreen.m_96638_() && !slot.m_7993_().m_41619_()) {
                this.cancel = true;
            }
            if (!this.cancel) {
                this.clickedSlotId = slot.f_40219_;
                RSInsertExportUpgrade.NETWORK_HANDLER.sendToServer(new LockSlotUpdateMessage(this.clickedSlotId, true));
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        Slot slot = this.m_97744_(mouseX, mouseY);
        if (!this.cancel && slot instanceof UpgradePlayerSlot) {
            ItemStack itemstack;
            ItemStack itemStack = itemstack = this.f_97711_.m_41619_() ? ((UpgradeContainerMenu)this.f_97732_).m_142621_() : this.f_97711_;
            if ((!this.dragging || slot.m_7993_().m_41619_() && slot.f_40219_ == this.clickedSlotId) && itemstack.m_41619_() && this.timeSinceRendered >= 20) {
                int slotId = slot.f_40219_ - (18 + (this.type == UpgradeType.EXPORT ? 2 : 0));
                if (this.type == UpgradeType.INSERT) {
                    this.selectedInventorySlots[slotId] = this.selectedInventorySlots[slotId] == 0 ? 1 : 0;
                } else if (button == 0) {
                    if (this.selectedInventorySlots[slotId] >= 18) {
                        this.selectedInventorySlots[slotId] = 0;
                    } else {
                        int n = slotId;
                        this.selectedInventorySlots[n] = this.selectedInventorySlots[n] + 1;
                    }
                } else {
                    this.selectedInventorySlots[slotId] = 0;
                }
                this.sendUpdate();
            }
        }
        this.cancel = false;
        this.dragging = false;
        this.clickedSlotId = -1;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        ItemStack itemstack;
        this.dragging = true;
        ItemStack itemStack = itemstack = this.f_97711_.m_41619_() ? ((UpgradeContainerMenu)this.f_97732_).m_142621_() : this.f_97711_;
        if (this.clickedSlotId != -1 && itemstack.m_41619_()) {
            this.m_6597_((Slot)((UpgradeContainerMenu)this.f_97732_).f_38839_.get(this.clickedSlotId), this.clickedSlotId, button, ClickType.PICKUP);
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public static void renderSlotHighlight(GuiGraphics graphics, UpgradeType type, Font font, int x, int y, boolean checked, int filterIndex) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
        if (checked) {
            if (type == UpgradeType.INSERT) {
                graphics.m_280163_(CHECKMARK, x + 7, y, 0.0f, 0.0f, 9, 8, 9, 8);
            } else {
                graphics.m_280488_(font, String.valueOf(filterIndex), x + 16 - font.m_92895_(String.valueOf(filterIndex)), y, Color.GREEN.hashCode());
            }
        } else {
            graphics.m_280163_(XMARK, x + 9, y, 0.0f, 0.0f, 7, 7, 7, 7);
        }
        graphics.m_280168_().m_85849_();
    }

    public void renderForeground(GuiGraphics graphics, int mouseX, int mouseY) {
        this.renderString(graphics, 7, 7, this.f_96539_.getString());
        this.renderString(graphics, 7, 69, I18n.m_118938_((String)"container.inventory", (Object[])new Object[0]));
    }

    public void sendUpdate() {
        RSInsertExportUpgrade.NETWORK_HANDLER.sendToServer(new UpgradeUpdateMessage(this.type.getId(), this.compare, this.mode, this.selectedInventorySlots, ((UpgradeContainerMenu)this.m_6262_()).selectedSideButton));
    }
}

