/*
 * Decompiled with CFR 0.152.
 */
package com.shblock.integrated_proxy.tileentity;

import com.shblock.integrated_proxy.IntegratedProxy;
import com.shblock.integrated_proxy.block.BlockAccessProxy;
import com.shblock.integrated_proxy.block.BlockAccessProxyConfig;
import com.shblock.integrated_proxy.id_network.AccessProxyNetworkElement;
import com.shblock.integrated_proxy.network.packet.RemoveProxyRenderPacket;
import com.shblock.integrated_proxy.network.packet.UpdateProxyDisableRenderPacket;
import com.shblock.integrated_proxy.network.packet.UpdateProxyDisplayRotationPacket;
import com.shblock.integrated_proxy.network.packet.UpdateProxyDisplayValuePacket;
import com.shblock.integrated_proxy.network.packet.UpdateProxyRenderPacket;
import com.shblock.integrated_proxy.storage.AccessProxyCollection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.integrateddynamics.api.block.IDynamicRedstone;
import org.cyclops.integrateddynamics.api.block.IVariableContainer;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkEventListener;
import org.cyclops.integrateddynamics.api.network.event.INetworkEvent;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.capability.variablecontainer.VariableContainerConfig;
import org.cyclops.integrateddynamics.capability.variablecontainer.VariableContainerDefault;
import org.cyclops.integrateddynamics.capability.variablefacade.VariableFacadeHolderConfig;
import org.cyclops.integrateddynamics.core.evaluate.InventoryVariableEvaluator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.network.event.VariableContentsUpdatedEvent;
import org.cyclops.integrateddynamics.core.tileentity.TileCableConnectableInventory;
import org.cyclops.integratedtunnels.core.part.PartTypeInterfacePositionedAddon;

public class TileAccessProxy
extends TileCableConnectableInventory
implements IDirtyMarkListener,
INetworkEventListener<AccessProxyNetworkElement> {
    public static final int SLOT_X = 0;
    public static final int SLOT_Y = 1;
    public static final int SLOT_Z = 2;
    public static final int SLOT_DISPLAY = 3;
    public final InventoryVariableEvaluator<ValueTypeInteger.ValueInteger> evaluator_x;
    public final InventoryVariableEvaluator<ValueTypeInteger.ValueInteger> evaluator_y;
    public final InventoryVariableEvaluator<ValueTypeInteger.ValueInteger> evaluator_z;
    public final InventoryVariableEvaluator<IValue> evaluator_display;
    private IValue display_value;
    private final IVariableContainer variableContainer;
    private boolean shouldSendUpdateEvent = false;
    public DimPos target;
    public int pos_mode = 0;
    public int[] display_rotations = new int[]{0, 0, 0, 0, 0, 0};
    private int[] redstone_powers = new int[]{0, 0, 0, 0, 0, 0};
    private int[] strong_powers = new int[]{0, 0, 0, 0, 0, 0};
    public boolean disable_render = false;

    public TileAccessProxy() {
        super(4, "variables", 1);
        this.inventory.addDirtyMarkListener((IDirtyMarkListener)this);
        this.addCapabilityInternal(NetworkElementProviderConfig.CAPABILITY, new NetworkElementProviderSingleton(){

            public INetworkElement createNetworkElement(World world, BlockPos blockPos) {
                return new AccessProxyNetworkElement(DimPos.of((World)world, (BlockPos)blockPos));
            }
        });
        this.variableContainer = new VariableContainerDefault();
        this.addCapabilityInternal(VariableContainerConfig.CAPABILITY, this.variableContainer);
        this.evaluator_x = new InventoryVariableEvaluator((IInventory)this, 0, (IValueType)ValueTypes.INTEGER);
        this.evaluator_y = new InventoryVariableEvaluator((IInventory)this, 1, (IValueType)ValueTypes.INTEGER);
        this.evaluator_z = new InventoryVariableEvaluator((IInventory)this, 2, (IValueType)ValueTypes.INTEGER);
        this.evaluator_display = new InventoryVariableEvaluator((IInventory)this, 3, (IValueType)ValueTypes.CATEGORY_ANY);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return super.func_94041_b(index, stack) && (stack.func_190926_b() || stack.hasCapability(VariableFacadeHolderConfig.CAPABILITY, null));
    }

    public boolean func_180462_a(int slot, ItemStack itemStack, EnumFacing side) {
        return false;
    }

    public boolean func_180461_b(int slot, ItemStack itemStack, EnumFacing side) {
        return false;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74768_a("pos_mode", this.pos_mode);
        NBTClassType.writeNbt(List.class, (String)"errors_x", (Object)this.evaluator_x.getErrors(), (NBTTagCompound)tag);
        NBTClassType.writeNbt(List.class, (String)"errors_y", (Object)this.evaluator_y.getErrors(), (NBTTagCompound)tag);
        NBTClassType.writeNbt(List.class, (String)"errors_z", (Object)this.evaluator_z.getErrors(), (NBTTagCompound)tag);
        NBTClassType.writeNbt(List.class, (String)"errors_display", (Object)this.evaluator_display.getErrors(), (NBTTagCompound)tag);
        tag.func_74783_a("display_rotations", this.display_rotations);
        if (this.getDisplayValue() != null) {
            tag.func_74782_a("displayValue", (NBTBase)ValueHelpers.serialize((IValue)this.getDisplayValue()));
        }
        tag.func_74783_a("rs_power", this.redstone_powers);
        tag.func_74783_a("strong_power", this.strong_powers);
        tag.func_74757_a("disable_render", this.disable_render);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.pos_mode = tag.func_74762_e("pos_mode");
        this.evaluator_x.setErrors((List)NBTClassType.readNbt(List.class, (String)"errors_x", (NBTTagCompound)tag));
        this.evaluator_y.setErrors((List)NBTClassType.readNbt(List.class, (String)"errors_y", (NBTTagCompound)tag));
        this.evaluator_z.setErrors((List)NBTClassType.readNbt(List.class, (String)"errors_z", (NBTTagCompound)tag));
        this.evaluator_display.setErrors((List)NBTClassType.readNbt(List.class, (String)"errors_display", (NBTTagCompound)tag));
        this.display_rotations = tag.func_74759_k("display_rotations");
        if (tag.func_150297_b("displayValue", MinecraftHelpers.NBTTag_Types.NBTTagCompound.ordinal())) {
            this.setDisplayValue(ValueHelpers.deserialize((NBTTagCompound)tag.func_74775_l("displayValue")));
        } else {
            this.setDisplayValue(null);
        }
        if (tag.func_74764_b("rs_power")) {
            this.redstone_powers = tag.func_74759_k("rs_power");
        }
        if (tag.func_74764_b("strong_power")) {
            this.strong_powers = tag.func_74759_k("strong_power");
        }
        if (tag.func_74764_b("disable_render")) {
            this.disable_render = tag.func_74767_n("disable_render");
        }
        this.shouldSendUpdateEvent = true;
    }

    public IValue getDisplayValue() {
        return this.display_value;
    }

    public void setDisplayValue(IValue displayValue) {
        this.display_value = displayValue;
    }

    public void rotateDisplayValue(EnumFacing side) {
        int ord;
        int n = ord = side.func_176745_a();
        this.display_rotations[n] = this.display_rotations[n] + 1;
        if (this.display_rotations[ord] >= 4) {
            this.display_rotations[ord] = 0;
        }
        this.func_70296_d();
        IntegratedProxy._instance.getPacketHandler().sendToAll((PacketBase)new UpdateProxyDisplayRotationPacket(DimPos.of((World)this.field_145850_b, (BlockPos)this.field_174879_c), this.display_rotations));
    }

    public void changeDisableRender() {
        this.disable_render = !this.disable_render;
        this.func_70296_d();
        IntegratedProxy._instance.getPacketHandler().sendToAll((PacketBase)new UpdateProxyDisableRenderPacket(DimPos.of((World)this.field_145850_b, (BlockPos)this.field_174879_c), this.disable_render));
    }

    protected void refreshVariables(boolean sendVariablesUpdateEvent) {
        this.evaluator_x.refreshVariable(this.getNetwork(), false);
        this.evaluator_y.refreshVariable(this.getNetwork(), false);
        this.evaluator_z.refreshVariable(this.getNetwork(), false);
        this.evaluator_display.refreshVariable(this.getNetwork(), sendVariablesUpdateEvent);
    }

    public int getVariableIntValue(InventoryVariableEvaluator<ValueTypeInteger.ValueInteger> evaluator) throws EvaluationException {
        return ((ValueTypeInteger.ValueInteger)((ValueTypeInteger.ValueInteger)evaluator.getVariable(this.getNetwork()).getValue()).cast((IValueType)ValueTypes.INTEGER)).getRawValue();
    }

    private boolean isTargetOutOfRange(BlockPos target) {
        if (BlockAccessProxyConfig.range < 0) {
            return false;
        }
        return Math.abs(target.func_177958_n() - this.field_174879_c.func_177958_n()) > BlockAccessProxyConfig.range || Math.abs(target.func_177956_o() - this.field_174879_c.func_177956_o()) > BlockAccessProxyConfig.range || Math.abs(target.func_177952_p() - this.field_174879_c.func_177952_p()) > BlockAccessProxyConfig.range;
    }

    private void updateTargetPos() {
        if (!this.func_145831_w().field_72995_K) {
            DimPos old_target = this.target == null ? null : DimPos.of((int)this.target.getDimensionId(), (BlockPos)this.target.getBlockPos());
            try {
                this.target = this.pos_mode == 1 ? DimPos.of((World)this.field_145850_b, (BlockPos)new BlockPos(this.isVariableAvailable(this.evaluator_x) ? this.getVariableIntValue(this.evaluator_x) : this.field_174879_c.func_177958_n(), this.isVariableAvailable(this.evaluator_y) ? this.getVariableIntValue(this.evaluator_y) : this.field_174879_c.func_177956_o(), this.isVariableAvailable(this.evaluator_z) ? this.getVariableIntValue(this.evaluator_z) : this.field_174879_c.func_177952_p())) : DimPos.of((World)this.field_145850_b, (BlockPos)new BlockPos(this.isVariableAvailable(this.evaluator_x) ? this.getVariableIntValue(this.evaluator_x) + this.field_174879_c.func_177958_n() : this.field_174879_c.func_177958_n(), this.isVariableAvailable(this.evaluator_y) ? this.getVariableIntValue(this.evaluator_y) + this.field_174879_c.func_177956_o() : this.field_174879_c.func_177956_o(), this.isVariableAvailable(this.evaluator_z) ? this.getVariableIntValue(this.evaluator_z) + this.field_174879_c.func_177952_p() : this.field_174879_c.func_177952_p()));
            }
            catch (EvaluationException e) {
                this.target = DimPos.of((World)this.field_145850_b, (BlockPos)this.field_174879_c);
            }
            if (this.isTargetOutOfRange(this.target.getBlockPos())) {
                this.target = DimPos.of((World)this.field_145850_b, (BlockPos)this.field_174879_c);
            }
            if (!this.target.equals((Object)old_target)) {
                if (old_target != null) {
                    this.notifyTargetChange();
                }
                IntegratedProxy._instance.getPacketHandler().sendToAll((PacketBase)new UpdateProxyRenderPacket(DimPos.of((World)this.field_145850_b, (BlockPos)this.field_174879_c), this.target));
                AccessProxyCollection.getInstance(this.field_145850_b).set(this.field_174879_c, this.target.getBlockPos());
                this.updateTargetBlock();
                if (old_target != null) {
                    this.updateTargetBlock(this.field_145850_b, old_target.getBlockPos());
                }
            }
        }
    }

    private boolean isVariableAvailable(InventoryVariableEvaluator<ValueTypeInteger.ValueInteger> evaluator) {
        if (evaluator.getVariable(this.getNetwork()) == null) {
            return false;
        }
        return evaluator.hasVariable() && evaluator.getErrors().isEmpty();
    }

    public boolean variableOk(InventoryVariableEvaluator<IValue> evaluator) {
        if (evaluator.getVariable(this.getNetwork()) == null) {
            return false;
        }
        return evaluator.hasVariable() && evaluator.getErrors().isEmpty();
    }

    public boolean variableIntegerOk(InventoryVariableEvaluator<ValueTypeInteger.ValueInteger> evaluator) {
        if (evaluator.getVariable(this.getNetwork()) == null) {
            return false;
        }
        return evaluator.hasVariable() && evaluator.getVariable(this.getNetwork()).getType() instanceof ValueTypeInteger && evaluator.getErrors().isEmpty();
    }

    public boolean setSideRedstonePower(EnumFacing side, IDynamicRedstone cap) {
        int[] old_strong = (int[])this.strong_powers.clone();
        int[] old_power = (int[])this.redstone_powers.clone();
        if (cap != null) {
            this.redstone_powers[side.func_176745_a()] = cap.getRedstoneLevel();
            this.strong_powers[side.func_176745_a()] = cap.isStrong() ? cap.getRedstoneLevel() : 0;
        } else {
            this.redstone_powers[side.func_176745_a()] = 0;
            this.strong_powers[side.func_176745_a()] = 0;
        }
        this.func_70296_d();
        return this.redstone_powers != old_power || this.strong_powers != old_strong;
    }

    public int getRedstonePowerForTarget() {
        int power = 0;
        for (int i : this.redstone_powers) {
            power = Math.max(power, i);
        }
        return power;
    }

    public int getStrongPowerForTarget() {
        int power = 0;
        for (int i : this.strong_powers) {
            power = Math.max(power, i);
        }
        return power;
    }

    public void onDirty() {
        if (!this.field_145850_b.field_72995_K) {
            this.refreshVariables(true);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (!MinecraftHelpers.isClientSide()) {
            this.shouldSendUpdateEvent = true;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    public void sendRemoveRenderPacket() {
        if (!this.field_145850_b.field_72995_K) {
            IntegratedProxy._instance.getPacketHandler().sendToAll((PacketBase)new RemoveProxyRenderPacket(DimPos.of((World)this.field_145850_b, (BlockPos)this.field_174879_c)));
        }
    }

    public void unRegisterEventHandle() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    protected void updateTileEntity() {
        super.updateTileEntity();
        if (this.shouldSendUpdateEvent && this.getNetwork() != null) {
            this.shouldSendUpdateEvent = false;
            this.refreshVariables(true);
        }
        if (!this.field_145850_b.field_72995_K) {
            boolean is_dirty = false;
            try {
                IValue value = this.evaluator_display.getVariable(this.getNetwork()).getValue();
                if (value != this.getDisplayValue()) {
                    is_dirty = true;
                }
                this.setDisplayValue(value);
            }
            catch (NullPointerException | EvaluationException e) {
                if (this.display_value != null) {
                    is_dirty = true;
                }
                this.setDisplayValue(null);
            }
            if (is_dirty) {
                this.func_70296_d();
                IntegratedProxy._instance.getPacketHandler().sendToAll((PacketBase)new UpdateProxyDisplayValuePacket(DimPos.of((World)this.field_145850_b, (BlockPos)this.field_174879_c), this.getDisplayValue()));
            }
            this.updateTargetPos();
        }
    }

    public void afterNetworkReAlive() {
        this.refreshVariables(true);
        this.updateTargetPos();
    }

    public boolean hasEventSubscriptions() {
        return true;
    }

    public Set<Class<? extends INetworkEvent>> getSubscribedEvents() {
        HashSet<Class<? extends INetworkEvent>> set = new HashSet<Class<? extends INetworkEvent>>();
        set.add(VariableContentsUpdatedEvent.class);
        return set;
    }

    public void onEvent(INetworkEvent event, AccessProxyNetworkElement networkElement) {
        if (event instanceof VariableContentsUpdatedEvent) {
            this.refreshVariables(false);
            this.updateTargetPos();
            this.sendUpdate();
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            IntegratedProxy._instance.getPacketHandler().sendToPlayer((PacketBase)new UpdateProxyRenderPacket(DimPos.of((World)this.field_145850_b, (BlockPos)this.field_174879_c), this.target), (EntityPlayerMP)event.player);
            IntegratedProxy._instance.getPacketHandler().sendToPlayer((PacketBase)new UpdateProxyDisplayValuePacket(DimPos.of((World)this.field_145850_b, (BlockPos)this.field_174879_c), this.getDisplayValue()), (EntityPlayerMP)event.player);
            IntegratedProxy._instance.getPacketHandler().sendToPlayer((PacketBase)new UpdateProxyDisplayRotationPacket(DimPos.of((World)this.field_145850_b, (BlockPos)this.field_174879_c), this.display_rotations), (EntityPlayerMP)event.player);
            IntegratedProxy._instance.getPacketHandler().sendToPlayer((PacketBase)new UpdateProxyDisableRenderPacket(DimPos.of((World)this.field_145850_b, (BlockPos)this.field_174879_c), this.disable_render), (EntityPlayerMP)event.player);
        }
    }

    public static void updateAfterBlockDestroy(World world, BlockPos pos) {
        for (EnumFacing offset : EnumFacing.field_82609_l) {
            world.func_190524_a(pos.func_177972_a(offset), (Block)BlockAccessProxy.getInstance(), pos);
        }
        TileAccessProxy.refreshFacePartNetwork(world, pos);
    }

    public void notifyTargetChange() {
        for (EnumFacing offset : EnumFacing.field_82609_l) {
            this.field_145850_b.func_190524_a(this.field_174879_c.func_177972_a(offset), this.func_145838_q(), this.field_174879_c);
        }
        this.refreshFacePartNetwork();
    }

    public void refreshFacePartNetwork() {
        TileAccessProxy.refreshFacePartNetwork(this.field_145850_b, this.field_174879_c);
    }

    public static void refreshFacePartNetwork(World world, BlockPos pos) {
        if (Loader.isModLoaded((String)"integratedtunnels")) {
            for (EnumFacing offset : EnumFacing.field_82609_l) {
                try {
                    PartHelpers.PartStateHolder partStateHolder = PartHelpers.getPart((PartPos)PartPos.of((World)world, (BlockPos)pos.func_177972_a(offset), (EnumFacing)offset.func_176734_d()));
                    if (partStateHolder == null || !(partStateHolder.getPart() instanceof PartTypeInterfacePositionedAddon)) continue;
                    NetworkHelpers.initNetwork((World)world, (BlockPos)pos.func_177972_a(offset), (EnumFacing)offset.func_176734_d());
                }
                catch (NullPointerException | ConcurrentModificationException runtimeException) {
                    // empty catch block
                }
            }
        }
    }

    public void updateTargetBlock(World world, BlockPos pos) {
        if (!world.func_175667_e(pos)) {
            return;
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            world.func_190524_a(pos, world.func_180495_p(pos).func_177230_c(), pos.func_177972_a(facing));
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (world.func_180495_p(pos.func_177972_a(facing)).func_177230_c() instanceof BlockAccessProxy) continue;
            world.func_190524_a(pos.func_177972_a(facing), world.func_180495_p(pos.func_177972_a(facing)).func_177230_c(), pos);
        }
    }

    public void updateTargetBlock() {
        if (this.target != null) {
            this.updateTargetBlock(this.field_145850_b, this.target.getBlockPos());
        }
    }

    @SubscribeEvent
    public void onTargetChanged(BlockEvent.NeighborNotifyEvent event) {
        try {
            if (event.getPos().equals((Object)this.target.getBlockPos()) && event.getWorld().equals(this.target.getWorld())) {
                this.notifyTargetChange();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

