/*
 * Decompiled with CFR 0.152.
 */
package com.shblock.integrated_proxy.storage;

import com.shblock.integrated_proxy.helper.BlockPosHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class AccessProxyCollection
extends WorldSavedData {
    public static final String NAME = "integrated_proxy_access_proxy_collection";
    private HashMap<BlockPos, BlockPos> map = new HashMap();

    public AccessProxyCollection(String name) {
        this();
    }

    public AccessProxyCollection() {
        super(NAME);
    }

    public static AccessProxyCollection getInstance(World world) {
        MapStorage storage = world.getPerWorldStorage();
        AccessProxyCollection instance = (AccessProxyCollection)storage.func_75742_a(AccessProxyCollection.class, NAME);
        if (instance == null) {
            instance = new AccessProxyCollection();
            storage.func_75745_a(NAME, (WorldSavedData)instance);
        }
        return instance;
    }

    public void set(BlockPos proxy, BlockPos target) {
        this.map.put(proxy, target);
        this.func_76185_a();
    }

    public void remove(BlockPos proxy) {
        this.map.remove(proxy);
        this.func_76185_a();
    }

    public HashSet<BlockPos> getProxiesFromTarget(BlockPos target) {
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        for (Map.Entry<BlockPos, BlockPos> entry : this.map.entrySet()) {
            if (!entry.getValue().equals((Object)target)) continue;
            set.add(entry.getKey());
        }
        return set;
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<BlockPos, BlockPos> entry : this.map.entrySet()) {
            list.func_74742_a((NBTBase)new NBTTagIntArray(BlockPosHelper.blockPosToSet(entry.getKey())));
            list.func_74742_a((NBTBase)new NBTTagIntArray(BlockPosHelper.blockPosToSet(entry.getValue())));
        }
        compound.func_74782_a("map", (NBTBase)list);
        return compound;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.map = new HashMap();
        NBTTagList list = nbt.func_150295_c("map", 11);
        for (int i = 0; i < list.func_74745_c() / 2; ++i) {
            this.map.put(BlockPosHelper.setToBlockPos(list.func_150306_c(i)), BlockPosHelper.setToBlockPos(list.func_150306_c(i + 1)));
        }
    }
}

