/*
 * Decompiled with CFR 0.152.
 */
package com.shblock.integrated_proxy.mixin;

import com.shblock.integrated_proxy.storage.AccessProxyCollection;
import com.shblock.integrated_proxy.tileentity.TileAccessProxy;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.MapStorage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={World.class})
public abstract class MixinWorldRedstone {
    @Shadow
    @Final
    public WorldProvider field_73011_w;

    @Shadow
    @Nullable
    public abstract TileEntity func_175625_s(BlockPos var1);

    @Shadow
    public abstract MapStorage getPerWorldStorage();

    @Shadow
    @Nullable
    public abstract MinecraftServer func_73046_m();

    @Inject(at={@At(value="RETURN")}, method={"Lnet/minecraft/world/World;getRedstonePower(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)I"}, cancellable=true)
    public void getRedstonePower(BlockPos pos, EnumFacing facing, CallbackInfoReturnable<Integer> callback) {
        MinecraftServer server = this.func_73046_m();
        if (server == null) {
            return;
        }
        WorldServer world = server.func_71218_a(this.field_73011_w.getDimension());
        if (world == null) {
            return;
        }
        AccessProxyCollection data = AccessProxyCollection.getInstance((World)world);
        HashSet<BlockPos> proxies = data.getProxiesFromTarget(pos.func_177972_a(facing.func_176734_d()));
        if (!proxies.isEmpty()) {
            int max_power = callback.getReturnValue();
            for (BlockPos proxy : proxies) {
                TileAccessProxy tile = (TileAccessProxy)this.func_175625_s(proxy);
                if (tile == null) continue;
                max_power = Math.max(max_power, tile.getRedstonePowerForTarget());
            }
            callback.setReturnValue(max_power);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"Lnet/minecraft/world/World;getStrongPower(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)I"}, cancellable=true)
    public void getStrongPower(BlockPos pos, EnumFacing facing, CallbackInfoReturnable<Integer> callback) {
        MinecraftServer server = this.func_73046_m();
        if (server == null) {
            return;
        }
        WorldServer world = server.func_71218_a(this.field_73011_w.getDimension());
        if (world == null) {
            return;
        }
        AccessProxyCollection data = AccessProxyCollection.getInstance((World)world);
        HashSet<BlockPos> proxies = data.getProxiesFromTarget(pos.func_177972_a(facing.func_176734_d()));
        if (!proxies.isEmpty()) {
            int max_power = callback.getReturnValue();
            for (BlockPos proxy : proxies) {
                TileAccessProxy tile = (TileAccessProxy)this.func_175625_s(proxy);
                if (tile == null) continue;
                max_power = Math.max(max_power, tile.getStrongPowerForTarget());
            }
            callback.setReturnValue(max_power);
        }
    }
}

