/*
 * Decompiled with CFR 0.152.
 */
package com.shblock.integrated_proxy.block;

import com.shblock.integrated_proxy.client.gui.GuiAccessProxy;
import com.shblock.integrated_proxy.inventory.container.ContainerAccessProxy;
import com.shblock.integrated_proxy.storage.AccessProxyCollection;
import com.shblock.integrated_proxy.tileentity.TileAccessProxy;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.api.block.IDynamicRedstone;
import org.cyclops.integrateddynamics.capability.dynamicredstone.DynamicRedstoneConfig;
import org.cyclops.integrateddynamics.core.block.BlockContainerGuiCabled;
import org.cyclops.integrateddynamics.core.helper.WrenchHelpers;
import org.cyclops.integratedtunnels.core.ExtendedFakePlayer;

@Mod.EventBusSubscriber(modid="integrated_proxy")
public class BlockAccessProxy
extends BlockContainerGuiCabled {
    private static BlockAccessProxy _instance;

    public static BlockAccessProxy getInstance() {
        return _instance;
    }

    public BlockAccessProxy(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, TileAccessProxy.class);
    }

    public Class<? extends Container> getContainer() {
        return ContainerAccessProxy.class;
    }

    public Class<? extends GuiScreen> getGui() {
        return GuiAccessProxy.class;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        if (!world.field_72995_K) {
            AccessProxyCollection.getInstance(world).set(pos, pos);
            TileAccessProxy te = (TileAccessProxy)world.func_175625_s(pos);
            if (te == null) {
                return;
            }
            te.target = DimPos.of((World)world, (BlockPos)pos);
            for (EnumFacing facing : EnumFacing.values()) {
                if (te.target == null || !world.func_175667_e(te.target.getBlockPos()) || te.func_145837_r()) continue;
                IDynamicRedstone cap = (IDynamicRedstone)TileHelpers.getCapability((DimPos)DimPos.of((World)world, (BlockPos)pos.func_177972_a(facing)), (EnumFacing)facing.func_176734_d(), (Capability)DynamicRedstoneConfig.CAPABILITY);
                te.setSideRedstonePower(facing, cap);
            }
        }
    }

    protected void onPreBlockDestroyed(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            TileAccessProxy te = (TileAccessProxy)world.func_175625_s(pos);
            if (te == null) {
                return;
            }
            te.sendRemoveRenderPacket();
            te.unRegisterEventHandle();
            AccessProxyCollection.getInstance(world).remove(pos);
            te.updateTargetBlock();
        }
        super.onPreBlockDestroyed(world, pos);
    }

    protected void onPostBlockDestroyed(World world, BlockPos pos) {
        super.onPostBlockDestroyed(world, pos);
        TileAccessProxy.updateAfterBlockDestroy(world, pos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                if (player.func_184586_b(hand).func_190926_b()) {
                    ((TileAccessProxy)world.func_175625_s(pos)).changeDisableRender();
                    return true;
                }
                return super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
            }
            if (WrenchHelpers.isWrench((EntityPlayer)player, (ItemStack)player.func_184586_b(hand), (World)world, (BlockPos)pos, (EnumFacing)side)) {
                ((TileAccessProxy)world.func_175625_s(pos)).rotateDisplayValue(side);
                return true;
            }
            return super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
        }
        if (!player.func_70093_af()) {
            if (WrenchHelpers.isWrench((EntityPlayer)player, (ItemStack)player.func_184586_b(hand), (World)world, (BlockPos)pos, (EnumFacing)side)) {
                return true;
            }
            return super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
        }
        return player.func_184586_b(hand).func_190926_b();
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, neighborBlock, fromPos);
        if (neighborBlock instanceof BlockAccessProxy) {
            return;
        }
        if (pos.func_177956_o() == fromPos.func_177956_o() && !world.field_72995_K) {
            IDynamicRedstone cap;
            BlockPos facing_vec = fromPos.func_177973_b(new Vec3i(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
            EnumFacing facing = EnumFacing.func_176737_a((float)facing_vec.func_177958_n(), (float)facing_vec.func_177956_o(), (float)facing_vec.func_177952_p());
            TileAccessProxy te = (TileAccessProxy)world.func_175625_s(pos);
            if (te != null && te.setSideRedstonePower(facing, cap = (IDynamicRedstone)TileHelpers.getCapability((DimPos)DimPos.of((World)world, (BlockPos)fromPos), (EnumFacing)facing.func_176734_d(), (Capability)DynamicRedstoneConfig.CAPABILITY))) {
                te.updateTargetBlock();
            }
        }
    }

    public boolean isKeepNBTOnDrop() {
        return false;
    }

    @SubscribeEvent
    public static void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        if (!Loader.isModLoaded((String)"integratedtunnels")) {
            return;
        }
        if (event.getWorld().func_180495_p(event.getPos()).func_177230_c() instanceof BlockAccessProxy && event.getPlayer() instanceof ExtendedFakePlayer) {
            event.setCanceled(true);
        }
    }
}

