/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.ae2insertexportcard.mixin;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.CalculationStrategy;
import appeng.api.networking.crafting.ICraftingPlan;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.core.definitions.AEItems;
import appeng.helpers.WirelessTerminalMenuHost;
import appeng.items.tools.powered.WirelessTerminalItem;
import appeng.me.helpers.ChannelPowerSrc;
import appeng.me.helpers.MachineSource;
import appeng.me.helpers.PlayerSource;
import appeng.util.ConfigInventory;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={WirelessTerminalItem.class})
public class MixinWirelessTerminalItem
extends Item {
    @Unique
    private Future<ICraftingPlan> ae2insertExportCard$craftingJob;

    public MixinWirelessTerminalItem(Item.Properties properties) {
        super(properties);
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        super.m_6883_(stack, level, entity, slotId, isSelected);
        if (level.m_5776_()) {
            return;
        }
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (!stack.m_41782_() || level.f_46443_) {
            return;
        }
        boolean inRange = false;
        IGrid grid = null;
        WirelessTerminalMenuHost host = null;
        Item item = stack.m_41720_();
        if (item instanceof WirelessTerminalItem) {
            WirelessTerminalItem wirelessTerminalItem = (WirelessTerminalItem)item;
            grid = wirelessTerminalItem.getLinkedGrid(stack, level, (Player)player);
            ItemMenuHost itemMenuHost = wirelessTerminalItem.getMenuHost((Player)player, slotId, stack, null);
            if (itemMenuHost instanceof WirelessTerminalMenuHost) {
                WirelessTerminalMenuHost menuHost;
                host = menuHost = (WirelessTerminalMenuHost)itemMenuHost;
                inRange = host.rangeCheck();
            }
        }
        if (!inRange) {
            return;
        }
        if (stack.m_41783_().m_128441_("upgrades")) {
            ListTag tagList = stack.m_41783_().m_128437_("upgrades", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                FuzzyMode fuzzyMode;
                boolean isInsertUpgrade = tagList.m_128728_(i).m_128461_("id").equals(new ResourceLocation("ae2insertexportcard", "insert_card").toString());
                boolean isExportUpgrade = tagList.m_128728_(i).m_128461_("id").equals(new ResourceLocation("ae2insertexportcard", "export_card").toString());
                int slot = tagList.m_128728_(i).m_128451_("Slot");
                CompoundTag tag = (CompoundTag)tagList.m_128728_(i).m_128423_("tag");
                if (tag == null || !isInsertUpgrade && !isExportUpgrade) continue;
                ItemStack upgrade = host.getUpgrades().getStackInSlot(slot);
                int[] selectedInventorySlots = tag.m_128465_("SelectedInventorySlots");
                IUpgradeInventory upgrades = UpgradeInventories.forItem((ItemStack)upgrade, (int)3, null);
                boolean invertFilter = upgrades.isInstalled((ItemLike)AEItems.INVERTER_CARD);
                String fz = upgrade.m_41784_().m_128461_("fuzzy_mode");
                try {
                    fuzzyMode = FuzzyMode.valueOf((String)fz);
                }
                catch (Throwable t) {
                    fuzzyMode = FuzzyMode.IGNORE_ALL;
                }
                for (int j = 0; j < selectedInventorySlots.length; ++j) {
                    if (selectedInventorySlots[j] < 1) continue;
                    ItemStack itemInInventory = player.m_150109_().m_8020_(j);
                    if (!isExportUpgrade && itemInInventory.m_41720_() == Items.f_41852_ || itemInInventory == stack) continue;
                    ConfigInventory filterConfig = ConfigInventory.configTypes((int)18, null);
                    filterConfig.readFromChildTag(tag, "filterConfig");
                    IGridNode node = host.getActionableNode();
                    if (node == null) {
                        return;
                    }
                    PlayerSource source = new PlayerSource((Player)player);
                    if (isInsertUpgrade) {
                        for (GenericStack filter : filterConfig.getAvailableStacks()) {
                            AEItemKey what = AEItemKey.of((ItemStack)itemInInventory);
                            if (what == null || grid == null || grid.getStorageService() == null) continue;
                            boolean successful = false;
                            if (upgrades.isInstalled((ItemLike)AEItems.FUZZY_CARD) ? invertFilter != what.fuzzyEquals((AEKey)filter.getKey(), fuzzyMode) : invertFilter != what.equals(filter.getKey())) {
                                long amount = StorageHelper.poweredInsert((IEnergySource)new ChannelPowerSrc(node, (IEnergySource)grid.getEnergyService()), (MEStorage)grid.getStorageService().getInventory(), (AEKey)what, (long)itemInInventory.m_41613_(), (IActionSource)source, (Actionable)Actionable.SIMULATE);
                                if (amount <= 0L) {
                                    return;
                                }
                                successful = true;
                            }
                            if (!successful) continue;
                            StorageHelper.poweredInsert((IEnergySource)new ChannelPowerSrc(node, (IEnergySource)grid.getEnergyService()), (MEStorage)grid.getStorageService().getInventory(), (AEKey)what, (long)itemInInventory.m_41613_(), (IActionSource)source, (Actionable)Actionable.MODULATE);
                            player.m_150109_().m_6836_(j, ItemStack.f_41583_);
                            player.f_36096_.m_38946_();
                        }
                        continue;
                    }
                    for (int index = 0; index < filterConfig.size(); ++index) {
                        Optional playerInventory;
                        GenericStack filter;
                        filter = filterConfig.getStack(index);
                        if (filter == null || index != selectedInventorySlots[j] - 1 || !(playerInventory = player.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).resolve()).isPresent()) continue;
                        AEItemKey what = AEItemKey.of((ItemLike)itemInInventory.m_41720_());
                        if (!itemInInventory.m_41619_() && !(upgrades.isInstalled((ItemLike)AEItems.FUZZY_CARD) ? what.fuzzyEquals(filter.what(), fuzzyMode) : what.equals((Object)filter.what()))) continue;
                        int extractAmount = Math.min(itemInInventory.m_41741_() - itemInInventory.m_41613_(), itemInInventory.m_41741_());
                        int stackInteractionSize = upgrades.isInstalled((ItemLike)AEItems.SPEED_CARD) ? 64 : 1;
                        int size = Math.min(stackInteractionSize, extractAmount);
                        if (size <= 0) continue;
                        long extracted = StorageHelper.poweredExtraction((IEnergySource)new ChannelPowerSrc(node, (IEnergySource)grid.getEnergyService()), (MEStorage)grid.getStorageService().getInventory(), (AEKey)filter.what(), (long)size, (IActionSource)source, (Actionable)Actionable.MODULATE);
                        if (extracted <= 0L) {
                            ICraftingService craftingService;
                            if (!upgrades.isInstalled((ItemLike)AEItems.CRAFTING_CARD) || !(craftingService = grid.getCraftingService()).isCraftable(filter.what()) || craftingService.getRequestedAmount(filter.what()) > 0L) continue;
                            MachineSource src = new MachineSource(() -> ((IGrid)grid).getPivot());
                            if (this.ae2insertExportCard$craftingJob != null) {
                                try {
                                    ICraftingPlan job = null;
                                    if (this.ae2insertExportCard$craftingJob.isDone()) {
                                        job = this.ae2insertExportCard$craftingJob.get();
                                    }
                                    if (job != null) {
                                        craftingService.submitJob(job, null, null, false, (IActionSource)src);
                                        this.ae2insertExportCard$craftingJob = null;
                                    }
                                }
                                catch (InterruptedException | ExecutionException exception) {
                                    // empty catch block
                                }
                            }
                            this.ae2insertExportCard$craftingJob = craftingService.beginCraftingCalculation(level, () -> src, filter.what(), (long)size, CalculationStrategy.CRAFT_LESS);
                            continue;
                        }
                        ((IItemHandler)playerInventory.get()).insertItem(j, new ItemStack((ItemLike)filter.what().wrapForDisplayOrFilter().m_41720_(), (int)extracted), false);
                        player.f_36096_.m_38946_();
                    }
                }
            }
        }
    }
}

