/*
 * Decompiled with CFR 0.152.
 */
package readonly.galactictweaks.features;

import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.entities.EntityMeteor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import readonly.api.feature.Feature;
import readonly.galactictweaks.core.GCTLog;
import readonly.galactictweaks.core.gc.GalaxyCache;
import readonly.galactictweaks.modules.galacticraft.GalacticraftModuleConfig;

public class DimensionalComets
extends Feature {
    public static String comment = ">> INFO: Comets will not be allowed to spawn in the Nether <<\nspecify where and how often asteroids will drop in set dimensions\nsee file under `config\\GalacticTweaks\\Celestial_Lists.md` for valid dimension names/ID's\n";
    private List<DimCometData> dataEntires = new ArrayList<DimCometData>();
    private int logged = 0;

    public DimensionalComets() {
        this.category = "DimensionalComets";
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @Override
    public void postInit() {
        for (String data : GalacticraftModuleConfig.dimID_spawnrate.get()) {
            String[] entry = data.split(":");
            double spawnRate = Double.parseDouble(entry[1]);
            this.dataEntires.add(new DimCometData(entry[0], spawnRate));
            GCTLog.debug("Dimensional Comets: Dim [" + entry[0] + "], Freq: [" + spawnRate + "]");
        }
    }

    @SubscribeEvent
    public void entityLivingEvent(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entityLiving = event.getEntityLiving();
        if (entityLiving instanceof EntityPlayerMP) {
            this.onPlayerUpdate((EntityPlayerMP)entityLiving);
        }
    }

    private void onPlayerUpdate(EntityPlayerMP player) {
        for (DimCometData data : this.dataEntires) {
            this.meteors(player, data.getDimid(), data.getSpawnrate());
        }
    }

    protected void meteors(EntityPlayerMP player, int dimensionid, double spawnRate) {
        World world = player.field_70170_p;
        WorldProvider provider = world.field_73011_w;
        int dimId = provider.func_186058_p().func_186068_a();
        if (dimId == -1) {
            return;
        }
        if (dimId == dimensionid) {
            int f;
            if (provider instanceof IGalacticraftWorldProvider) {
                IGalacticraftWorldProvider gcprovider = (IGalacticraftWorldProvider)provider;
                double x = gcprovider.getMeteorFrequency();
                double spRate = 0.0;
                if (x > 0.0 && this.logged < 3) {
                    GCTLog.debug("Dimensional Comets: Dim " + dimensionid + " has preset MeteorFrequency of: " + x);
                    ++this.logged;
                    if (spawnRate > x) {
                        GCTLog.debug("Dimensional Comets: Adjusting specified SpawnRate to subtract preset MeteorFrequency");
                        ++this.logged;
                        spRate = spawnRate - x;
                        GCTLog.debug("Dimensional Comets: Adjusted SpawnRate to " + spRate);
                        ++this.logged;
                    } else {
                        GCTLog.debug("Dimensional Comets: Adjusting specified SpawnRate to add preset MeteorFrequency");
                        ++this.logged;
                        spRate = spawnRate + x;
                        GCTLog.debug("Dimensional Comets: Adjusted SpawnRate to " + spRate);
                        ++this.logged;
                    }
                } else {
                    spRate = spawnRate > x ? spawnRate - x : spawnRate + x;
                }
                f = this.getRealRate(spRate);
            } else {
                f = this.getRealRate(spawnRate);
            }
            this.run(world, f, player);
        }
    }

    private int getRealRate(double spawnRate) {
        return (int)(750.0 * this.getSpawnRate(spawnRate));
    }

    private double getSpawnRate(double spawnRate) {
        return 1.0 / spawnRate;
    }

    private void run(World world, int f, EntityPlayerMP player) {
        EntityMeteor meteor;
        int px;
        double motZ;
        double motX;
        int z;
        int x;
        int r;
        EntityPlayer closestPlayer;
        if (world.field_73012_v.nextInt(f) == 0 && ((closestPlayer = world.func_72890_a((Entity)player, 100.0)) == null || closestPlayer.func_145782_y() <= player.func_145782_y())) {
            r = world.func_73046_m().func_184103_al().func_72395_o();
            x = world.field_73012_v.nextInt(20) + 100;
            z = world.field_73012_v.nextInt(20) - 10;
            motX = world.field_73012_v.nextDouble() * 2.0 - 2.5;
            motZ = world.field_73012_v.nextDouble() * 5.0 - 2.5;
            px = MathHelper.func_76128_c((double)player.field_70165_t);
            if ((x + px >> 4) - (px >> 4) >= r) {
                x = ((px >> 4) + r << 4) - 1 - px;
            }
            meteor = new EntityMeteor(world, player.field_70165_t + (double)x, 355.0, player.field_70161_v + (double)z, motX, 0.0, motZ, 1);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)meteor);
            }
        }
        if (world.field_73012_v.nextInt(f * 3) == 0 && ((closestPlayer = world.func_72890_a((Entity)player, 100.0)) == null || closestPlayer.func_145782_y() <= player.func_145782_y())) {
            r = world.func_73046_m().func_184103_al().func_72395_o();
            x = world.field_73012_v.nextInt(20) + 100;
            z = world.field_73012_v.nextInt(20) - 10;
            motX = world.field_73012_v.nextDouble() * 2.0 - 2.5;
            motZ = world.field_73012_v.nextDouble() * 5.0 - 2.5;
            px = MathHelper.func_76128_c((double)player.field_70165_t);
            if ((x + px >> 4) - (px >> 4) >= r) {
                x = ((px >> 4) + r << 4) - 1 - px;
            }
            meteor = new EntityMeteor(world, player.field_70165_t + (double)x, 355.0, player.field_70161_v + (double)z, motX, 0.0, motZ, 6);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)meteor);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return GalacticraftModuleConfig.DIMENSIONAL_COMETS;
    }

    public class DimCometData {
        private int dimid;
        private double spawnrate;

        public DimCometData(String object, double rate) {
            try {
                this.dimid = Integer.parseInt(object);
            }
            catch (NumberFormatException e) {
                this.dimid = GalaxyCache.cache().getDimensionIdFromName(object);
            }
            this.spawnrate = rate;
        }

        DimCometData(int id, double rate) {
            this.dimid = id;
            this.spawnrate = rate;
        }

        public int getDimid() {
            return this.dimid;
        }

        public double getSpawnrate() {
            return this.spawnrate;
        }
    }
}

