/*
 * Decompiled with CFR 0.152.
 */
package readonly.galactictweaks.core.utils;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import org.apache.commons.lang3.StringUtils;
import readonly.galactictweaks.core.GCTLog;

public final class Reflected {
    public static <T> T getInstance(Constructor<T> constructor, Object ... arguments) {
        try {
            return constructor.newInstance(arguments);
        }
        catch (Exception e) {
            GCTLog.error("Exception creating instance of " + constructor.getClass().getName(), e);
            return null;
        }
    }

    public static Constructor<?> getConstructor(String className, Class<?> ... argumentTypes) {
        if (className == null || argumentTypes == null) {
            GCTLog.error("The provided class name or arguments can't be null.", new Object[0]);
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getDeclaredConstructor(argumentTypes);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (Exception ex) {
            GCTLog.error("Exception getting constructor of " + className, ex);
            return null;
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... types) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(types);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (Exception ex) {
            GCTLog.error("Exception getting constructor of " + clazz.getName(), ex);
            return null;
        }
    }

    public static <T> T getObject(Object object, String ... fieldNames) {
        Class<?> cls = object.getClass();
        for (String field : fieldNames) {
            try {
                Field result = cls.getDeclaredField(field);
                result.setAccessible(true);
                return (T)result.get(object);
            }
            catch (Exception ex) {
                GCTLog.error("Exception in getObject()", ex);
            }
        }
        GCTLog.error("Could not retrieve any object for the provided field names.", new Object[0]);
        return null;
    }

    public static <T> T getFinalObject(Object object, String ... fieldNames) {
        Class<?> cls = object.getClass();
        for (String field : fieldNames) {
            try {
                Field result = cls.getDeclaredField(field);
                result.setAccessible(true);
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(result, result.getModifiers() & 0xFFFFFFEF);
                return (T)result.get(object);
            }
            catch (Exception ex) {
                GCTLog.error("Exception in getFinalObject()", ex);
            }
        }
        GCTLog.error("Could not retrieve any final object for the provided field names.", new Object[0]);
        return null;
    }

    public static <T> T getStaticObject(Class<?> clazz, String ... fieldNames) {
        for (String field : fieldNames) {
            try {
                Field result = clazz.getDeclaredField(field);
                result.setAccessible(true);
                return (T)result.get(null);
            }
            catch (Exception e) {
                GCTLog.error("Exception in getStaticObject()", e);
            }
        }
        GCTLog.error("Could not retrieve any static object for the provided field names.", new Object[0]);
        return null;
    }

    public static <T> T getStaticObject(String className, String ... fieldNames) {
        try {
            Class<?> clazz = Class.forName(className);
            return Reflected.getStaticObject(clazz, fieldNames);
        }
        catch (ClassNotFoundException e) {
            GCTLog.error("Exception in getStaticObject()", e);
            GCTLog.error("Could not retrieve any static object for the provided field names.", new Object[0]);
            return null;
        }
    }

    public static <T, E> T getPrivateValue(Class<? super E> classToAccess, @Nullable E instance, String fieldName) {
        try {
            return (T)Reflected.findField(classToAccess, fieldName, null).get(instance);
        }
        catch (Exception e) {
            e.getStackTrace();
            return null;
        }
    }

    public static <T, E> T getPrivateValue(Class<? super E> classToAccess, @Nullable E instance, String fieldName, @Nullable String fieldObfName) {
        try {
            return (T)Reflected.findField(classToAccess, fieldName, fieldObfName).get(instance);
        }
        catch (Exception e) {
            e.getStackTrace();
            return null;
        }
    }

    public static <T, E> void setPrivateValue(Class<? super T> classToAccess, @Nullable T instance, @Nullable E value, String fieldName) {
        try {
            Reflected.findField(classToAccess, fieldName, null).set(instance, value);
        }
        catch (Exception e) {
            e.getStackTrace();
        }
    }

    public static <T, E> void setPrivateValue(Class<? super T> classToAccess, @Nullable T instance, @Nullable E value, String fieldName, @Nullable String fieldObfName) {
        try {
            Reflected.findField(classToAccess, fieldName, fieldObfName).set(instance, value);
        }
        catch (Exception e) {
            e.getStackTrace();
        }
    }

    public static Field findField(@Nonnull Class<?> clazz, @Nonnull String fieldName, @Nullable String fieldObfName) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)fieldName), (Object)"Field name cannot be empty");
        String nameToFind = FMLLaunchHandler.isDeobfuscatedEnvironment() ? fieldName : (String)MoreObjects.firstNonNull((Object)fieldObfName, (Object)fieldName);
        try {
            Field f = clazz.getDeclaredField(nameToFind);
            f.setAccessible(true);
            return f;
        }
        catch (Exception e) {
            e.getStackTrace();
            return null;
        }
    }

    private Reflected() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

