/*
 * Decompiled with CFR 0.152.
 */
package readonly.galactictweaks.core.gc;

import java.util.Optional;
import java.util.function.Predicate;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import net.minecraftforge.fml.common.Loader;
import readonly.galactictweaks.core.GCTLog;

public final class CelestialReference {
    private Optional<CelestialBody> body;
    private Integer dimId = null;
    private String name = null;

    public static CelestialReference of(String data) {
        try {
            return new CelestialReference(Integer.parseInt(data));
        }
        catch (NumberFormatException e) {
            if (data.split(":").length > 1) {
                if (data.split(":").length >= 3) {
                    throw new IllegalArgumentException("Attempted to create CelestialReference with more than 2 IdRef's: [" + data + "]");
                }
                String modid = data.split(":")[0];
                String name = data.split(":")[1];
                if (modid.equals("galacticraftcore") || modid.equals("galacticraftplanets")) {
                    return new CelestialReference(name);
                }
                return new CelestialReference(modid, name);
            }
            return new CelestialReference(data);
        }
    }

    private CelestialReference(int dimId) {
        this.body = Optional.ofNullable(GalaxyRegistry.getCelestialBodyFromDimensionID((int)dimId));
        this.dimId = dimId;
    }

    private CelestialReference(String name) {
        this.body = GalaxyRegistry.getAllReachableBodies().stream().filter(CelestialReference.withName(name)).findFirst();
        this.name = name;
    }

    private CelestialReference(String modid, String name) {
        if (Loader.isModLoaded((String)modid)) {
            this.body = GalaxyRegistry.getAllReachableBodies().stream().filter(CelestialBody.filter((String)modid)).filter(CelestialReference.withName(name)).findFirst();
            this.name = modid + ":" + name;
        } else {
            GCTLog.error("Attempted to create CelestialReference for non-existent addon [ modid: '" + modid + "' , name: '" + name + "' ]", new Object[0]);
            this.body = Optional.empty();
        }
    }

    static Predicate<CelestialBody> withName(final String name) {
        return new Predicate<CelestialBody>(){

            @Override
            public boolean test(CelestialBody celestialObject) {
                return celestialObject.getName().equals(name);
            }
        };
    }

    public String getIdentifier() {
        return this.dimId != null ? String.valueOf(this.dimId) : this.name;
    }

    public Optional<CelestialBody> getBody() {
        return this.body;
    }

    public Integer getDimId() {
        return this.dimId;
    }

    public String getName() {
        return this.name;
    }
}

