/*
 * Decompiled with CFR 0.152.
 */
package readonly.galactictweaks.core.client.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import readonly.galactictweaks.core.client.gui.element.GuiElement;

@SideOnly(value=Side.CLIENT)
public abstract class GCTGui
extends GuiScreen {
    private final List<GuiElement> declaredElements = new ArrayList<GuiElement>();
    private int nextComponentID = 0;
    private int pages = 0;
    private int currentPage = 0;

    public GCTGui() {
        this.buildGui();
    }

    public final void func_73866_w_() {
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public abstract void buildGui();

    public final void func_73876_c() {
        this.updateGui();
        for (GuiElement comp : this.declaredElements) {
            comp.updateElement();
        }
    }

    public abstract void updateGui();

    public abstract boolean func_73868_f();

    public abstract boolean doesEscCloseGui();

    public void nextPage() {
        if (this.currentPage < this.pages) {
            ++this.currentPage;
        }
    }

    public void prevPage() {
        if (this.currentPage > 0) {
            --this.currentPage;
        }
    }

    public void setPage(int page) {
        if (page < this.pages) {
            this.currentPage = page;
        }
    }

    public final void addComponent(GuiElement element) {
        this.declaredElements.add(element);
    }

    public final void addAllComponents(GuiElement ... elements) {
        for (GuiElement c : elements) {
            this.addComponent(c);
        }
    }

    public void setAmountOfPages(int pages) {
        this.pages = pages;
    }

    public void assignComponentToPage(GuiElement comp, int page) {
        comp.assignToPage(page);
    }

    @Deprecated
    protected final <T extends GuiButton> T func_189646_b(T buttonIn) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected final void func_146284_a(GuiButton button) {
    }

    public final void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawBackground();
        for (GuiElement comp : this.declaredElements) {
            if (comp.getAssignedPage() != -1 && comp.getAssignedPage() != this.currentPage) continue;
            comp.draw(mouseX, mouseY, partialTicks);
        }
        for (GuiElement comp : Lists.reverse(this.declaredElements)) {
            if (comp.getAssignedPage() != -1 && comp.getAssignedPage() != this.currentPage || !comp.canHaveTooltip() || !this.isHovered(comp, mouseX, mouseY) || !comp.isVisible()) continue;
            ArrayList<String> list = new ArrayList<String>();
            if (comp.getTooltips() != null) {
                list.addAll(Arrays.asList(comp.getTooltips()));
            }
            if (list.isEmpty()) continue;
            this.func_146283_a(list, mouseX, mouseY);
            break;
        }
    }

    protected void drawBackground() {
        if (this.field_146297_k.field_71441_e != null) {
            this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -1072689136, -804253680);
        } else {
            GlStateManager.func_179140_f();
            GlStateManager.func_179106_n();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            this.field_146297_k.func_110434_K().func_110577_a(field_110325_k);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            bufferbuilder.func_181662_b(0.0, (double)this.field_146295_m, 0.0).func_187315_a(0.0, (double)((float)this.field_146295_m / 32.0f + 0.0f)).func_181669_b(64, 64, 64, 255).func_181675_d();
            bufferbuilder.func_181662_b((double)this.field_146294_l, (double)this.field_146295_m, 0.0).func_187315_a((double)((float)this.field_146294_l / 32.0f), (double)((float)this.field_146295_m / 32.0f + 0.0f)).func_181669_b(64, 64, 64, 255).func_181675_d();
            bufferbuilder.func_181662_b((double)this.field_146294_l, 0.0, 0.0).func_187315_a((double)((float)this.field_146294_l / 32.0f), 0.0).func_181669_b(64, 64, 64, 255).func_181675_d();
            bufferbuilder.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 0.0).func_181669_b(64, 64, 64, 255).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    private boolean isHovered(GuiElement comp, int mouseX, int mouseY) {
        if (comp.getAssignedPage() != -1 && comp.getAssignedPage() != this.currentPage) {
            return false;
        }
        int x = comp.getX();
        int y = comp.getY();
        int w = comp.getWidth();
        int h = comp.getHeight();
        return mouseX >= x && mouseY >= y && mouseX < x + w && mouseY < y + h;
    }

    public final GuiElement getComponent(int index) {
        return this.declaredElements.get(index);
    }

    public final void openGui(GuiScreen gui) {
        if (gui == null) {
            this.field_146297_k.func_147108_a(null);
        } else {
            this.field_146297_k.func_147108_a(gui);
        }
    }

    public void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        for (GuiElement comp : this.declaredElements) {
            if (comp.getAssignedPage() != -1 && comp.getAssignedPage() != this.currentPage) continue;
            comp.mouseClick(mouseX, mouseY, mouseButton);
        }
    }

    public void func_146286_b(int mouseX, int mouseY, int state) {
        for (GuiElement comp : this.declaredElements) {
            if (comp.getAssignedPage() != -1 && comp.getAssignedPage() != this.currentPage) continue;
            comp.mouseReleased(mouseX, mouseY, state);
        }
    }

    public void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 1 && this.doesEscCloseGui()) {
            this.field_146297_k.func_147108_a((GuiScreen)null);
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
        }
        for (GuiElement comp : this.declaredElements) {
            if (comp.getAssignedPage() != -1 && comp.getAssignedPage() != this.currentPage) continue;
            comp.keyTyped(typedChar, keyCode);
        }
    }

    public void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        for (GuiElement comp : this.declaredElements) {
            if (comp.getAssignedPage() != -1 && comp.getAssignedPage() != this.currentPage) continue;
            comp.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        }
    }

    public void func_146274_d() throws IOException {
        for (GuiElement comp : this.declaredElements) {
            if (comp.getAssignedPage() != -1 && comp.getAssignedPage() != this.currentPage) continue;
            comp.handleMouseInput();
        }
        super.func_146274_d();
    }

    public void func_146282_l() throws IOException {
        for (GuiElement element : this.declaredElements) {
            if (element.getAssignedPage() != -1 && element.getAssignedPage() != this.currentPage) continue;
            element.handleKeyboardInput();
        }
        super.func_146282_l();
    }
}

