/*
 * Decompiled with CFR 0.152.
 */
package readonly.galactictweaks.core.client.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;

public final class ALonelyCelestialScreen
extends GuiCelestialSelection {
    public ALonelyCelestialScreen(boolean mapMode, List<CelestialBody> possibleBodies, boolean canCreateStations) {
        super(mapMode, possibleBodies, canCreateStations);
    }

    public void func_73866_w_() {
        this.bodiesToRender.clear();
        for (Planet planet : GalaxyRegistry.getPlanets()) {
            if (!planet.isReachable()) continue;
            this.bodiesToRender.add(planet);
        }
        for (Moon moon : GalaxyRegistry.getMoons()) {
            if (!moon.getParentPlanet().isReachable() || !moon.isReachable()) continue;
            this.bodiesToRender.add(moon);
        }
        for (Satellite satellite : GalaxyRegistry.getSatellites()) {
            if (!satellite.getParentPlanet().isReachable()) continue;
            this.bodiesToRender.add(satellite);
        }
        GuiCelestialSelection.BORDER_SIZE = this.field_146294_l / 65;
        GuiCelestialSelection.BORDER_EDGE_SIZE = GuiCelestialSelection.BORDER_SIZE / 4;
        for (SolarSystem solarSystem : GalaxyRegistry.getSolarSystems()) {
            if (!GalaxyRegistry.getPlanetsForSolarSystem((SolarSystem)solarSystem).stream().filter(CelestialBody.filterReachable()).findAny().isPresent()) continue;
            this.bodiesToRender.add(solarSystem.getMainStar());
        }
    }

    protected List<CelestialBody> getChildren(Object object) {
        ArrayList bodyList = Lists.newArrayList();
        if (object instanceof Planet) {
            List moons = GalaxyRegistry.getMoonsForPlanet((Planet)((Planet)object));
            for (Moon moon : moons) {
                if (!moon.isReachable()) continue;
                bodyList.add(moon);
            }
        } else if (object instanceof SolarSystem) {
            List planets = GalaxyRegistry.getPlanetsForSolarSystem((SolarSystem)((SolarSystem)object));
            for (Planet planet : planets) {
                if (!planet.isReachable()) continue;
                bodyList.add(planet);
            }
        }
        Collections.sort(bodyList);
        return bodyList;
    }
}

