/*
 * Decompiled with CFR 0.152.
 */
package readonly.api.versioning.expr;

import readonly.api.versioning.Version;
import readonly.api.versioning.expr.Expression;
import readonly.api.versioning.expr.Expressions;

public class CompositeExpression
implements Expression {
    private Expression exprTree;

    public CompositeExpression(Expression expr) {
        this.exprTree = expr;
    }

    public CompositeExpression and(Expression expr) {
        this.exprTree = new Expressions.And(this.exprTree, expr);
        return this;
    }

    public CompositeExpression or(Expression expr) {
        this.exprTree = new Expressions.Or(this.exprTree, expr);
        return this;
    }

    public boolean interpret(String version) {
        return this.interpret(Version.of(version));
    }

    @Override
    public boolean interpret(Version version) {
        return this.exprTree.interpret(version);
    }

    public static class Helper {
        public static CompositeExpression not(Expression expr) {
            return new CompositeExpression(new Expressions.Not(expr));
        }

        public static CompositeExpression eq(Version version) {
            return new CompositeExpression(new Expressions.Equal(version));
        }

        public static CompositeExpression eq(String version) {
            return Helper.eq(Version.of(version));
        }

        public static CompositeExpression neq(Version version) {
            return new CompositeExpression(new Expressions.NotEqual(version));
        }

        public static CompositeExpression neq(String version) {
            return Helper.neq(Version.of(version));
        }

        public static CompositeExpression gt(Version version) {
            return new CompositeExpression(new Expressions.Greater(version));
        }

        public static CompositeExpression gt(String version) {
            return Helper.gt(Version.of(version));
        }

        public static CompositeExpression gte(Version version) {
            return new CompositeExpression(new Expressions.GreaterOrEqual(version));
        }

        public static CompositeExpression gte(String version) {
            return Helper.gte(Version.of(version));
        }

        public static CompositeExpression lt(Version version) {
            return new CompositeExpression(new Expressions.Less(version));
        }

        public static CompositeExpression lt(String version) {
            return Helper.lt(Version.of(version));
        }

        public static CompositeExpression lte(Version version) {
            return new CompositeExpression(new Expressions.LessOrEqual(version));
        }

        public static CompositeExpression lte(String version) {
            return Helper.lte(Version.of(version));
        }
    }
}

