/*
 * Decompiled with CFR 0.152.
 */
package readonly.api.versioning;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import readonly.api.versioning.Version;
import readonly.api.versioning.Versions;

public class VersionSet
extends TreeSet<Version>
implements SortedSet<Version> {
    private static final long serialVersionUID = 1L;

    public static VersionCollector collectVersions() {
        return new VersionCollector();
    }

    public VersionSet() {
        super(Version.BUILD_AWARE_ORDER);
    }

    public VersionSet(Comparator<Version> comparator) {
        super(comparator);
    }

    public VersionSet(Collection<Version> collection) {
        super(collection);
    }

    @SafeVarargs
    public VersionSet(Version ... versions) {
        this((Collection<Version>)Arrays.asList(versions));
    }

    @SafeVarargs
    public VersionSet(String ... versions) {
        this(Arrays.asList(versions).stream().map(Version::of).collect(Collectors.toList()));
    }

    public Version[] asArray() {
        return this.toArray(new Version[this.size()]);
    }

    public VersionSet extractSnapshots() {
        return new VersionSet((Collection<Version>)this.stream().filter(Version::isSnapshotVersion).collect(VersionSet.collectVersions()));
    }

    public VersionSet extractReleases() {
        return new VersionSet((Collection<Version>)this.stream().filter(Version::isStable).collect(VersionSet.collectVersions()));
    }

    @Override
    public SortedSet<Version> subSet(Version fromElement, Version toElement) {
        return new VersionSet((Collection<Version>)super.subSet(fromElement, toElement));
    }

    public SortedSet<Version> versionsUpTo(Version toElement) {
        return new VersionSet((Collection<Version>)super.headSet(toElement));
    }

    public SortedSet<Version> versionsFrom(Version fromElement) {
        return new VersionSet((Collection<Version>)super.tailSet(fromElement));
    }

    public Version oldest() {
        return (Version)super.first();
    }

    public Version latest() {
        return (Version)super.last();
    }

    public Version getVersion(String version) {
        return this.getVersion(Version.of(version));
    }

    public Version getVersion(Version version) {
        for (Version v : this) {
            if (!v.equals(version)) continue;
            return v;
        }
        return Version.Null();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public static class VersionCollector
    implements Collector<Version, TreeSet<Version>, TreeSet<Version>> {
        @Override
        public Supplier<TreeSet<Version>> supplier() {
            return VersionSet::new;
        }

        @Override
        public BiConsumer<TreeSet<Version>, Version> accumulator() {
            return (list, object) -> list.add(object);
        }

        @Override
        public BinaryOperator<TreeSet<Version>> combiner() {
            return (l1, l2) -> {
                l1.addAll(l2);
                return l1;
            };
        }

        @Override
        public Function<TreeSet<Version>, TreeSet<Version>> finisher() {
            return Versions::set;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return EnumSet.of(Collector.Characteristics.CONCURRENT);
        }
    }
}

