/*
 * Decompiled with CFR 0.152.
 */
package readonly.api.versioning;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

class NormalVersion
implements Comparable<NormalVersion> {
    static final NullNormalVersion NULL = new NullNormalVersion();
    private final Integer major;
    private final Integer minor;
    private final Integer patch;
    private final List<Integer> remaining = new LinkedList<Integer>();

    NormalVersion(Integer major, Integer minor, Integer patch) {
        if (major < 0 || minor < 0 || patch < 0) {
            throw new IllegalArgumentException("Major, minor and patch versions MUST be non-negative integers.");
        }
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    NormalVersion addRemainingIntegers(Integer ... integers) {
        this.remaining.addAll(Arrays.asList(integers));
        return this;
    }

    Integer getMajor() {
        return this.major;
    }

    Integer getMinor() {
        return this.minor;
    }

    Integer getPatch() {
        return this.patch;
    }

    NormalVersion incrementMajor() {
        return new NormalVersion(this.major + 1, 0, 0);
    }

    NormalVersion incrementMinor() {
        return new NormalVersion(this.major, this.minor + 1, 0);
    }

    NormalVersion incrementPatch() {
        return new NormalVersion(this.major, this.minor, this.patch + 1);
    }

    int getRemainingTotal() {
        return this.remaining.stream().mapToInt(Integer::valueOf).sum();
    }

    @Override
    public int compareTo(NormalVersion other) {
        int result = this.major - other.major;
        if (result == 0 && (result = this.minor - other.minor) == 0 && (result = this.patch - other.patch) == 0) {
            result = this.getRemainingTotal() - other.getRemainingTotal();
        }
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NormalVersion)) {
            return false;
        }
        return this.compareTo((NormalVersion)other) == 0;
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this.major;
        hash = 31 * hash + this.minor;
        hash = 31 * hash + this.patch;
        for (int i : this.remaining) {
            hash = 31 * hash + i;
        }
        return hash;
    }

    public String toString() {
        if (this.remaining.isEmpty()) {
            return String.format("%d.%d.%d", this.major, this.minor, this.patch);
        }
        return String.format("%d.%d.%d.%s", this.major, this.minor, this.patch, String.join((CharSequence)".", this.remaining.stream().map(String::valueOf).collect(Collectors.toList())));
    }

    private static class NullNormalVersion
    extends NormalVersion {
        NullNormalVersion() {
            super(0, 0, 0);
        }

        @Override
        NormalVersion incrementMajor() {
            throw new UnsupportedOperationException("Version is Null");
        }

        @Override
        NormalVersion incrementMinor() {
            throw new UnsupportedOperationException("Version is Null");
        }

        @Override
        NormalVersion incrementPatch() {
            throw new UnsupportedOperationException("Version is Null");
        }

        @Override
        public String toString() {
            return super.toString();
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object other) {
            return other instanceof NullNormalVersion;
        }

        @Override
        public int compareTo(NormalVersion other) {
            if (!this.equals(other)) {
                return 1;
            }
            return 0;
        }
    }
}

