/*
 * Decompiled with CFR 0.152.
 */
package readonly.api;

import com.google.common.primitives.UnsignedInts;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class RGB {
    private static final Map<String, RGB> NAMED_MAP = new HashMap<String, RGB>();
    private static final Pattern PATTERN_LEADING_JUNK = Pattern.compile("(#|0x)", 2);
    private static final Pattern PATTERN_HEX_CODE = Pattern.compile("(#|0[xX])?[0-9a-fA-F]{1,8}", 2);
    public static final int VALUE_WHITE = 0xFFFFFF;
    public static final RGB BLACK = RGB.named("Black", 0);
    public static final RGB BLUE = RGB.named("Blue", 255);
    public static final RGB DARKRED = RGB.named("DarkRed", 0x8B0000);
    public static final RGB LIGHTBLUE = RGB.named("LightBlue", 11393254);
    public static final RGB GREEN = RGB.named("Green", 32768);
    public static final RGB GREY = RGB.named("Grey", 0x808080);
    public static final RGB ORANGE = RGB.named("Orange", 16753920);
    public static final RGB ORANGERED = RGB.named("OrangeRed", 16729344);
    public static final RGB RED = RGB.named("Red", 0xFF0000);
    public static final RGB YELLOW = RGB.named("Yellow", 0xFFFF00);
    private final double red;
    private final double green;
    private final double blue;

    public RGB(int color) {
        this(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
    }

    public RGB(int red, int green, int blue) {
        this((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f);
    }

    public RGB(double red, double green, double blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public int getColor() {
        int r = (int)(this.red * 255.0) << 16;
        int g = (int)(this.green * 255.0) << 8;
        int b = (int)(this.blue * 255.0);
        return r + g + b;
    }

    public double red() {
        return this.red;
    }

    public double green() {
        return this.green;
    }

    public double blue() {
        return this.blue;
    }

    private static RGB named(String name, int color) {
        RGB c = new RGB(color);
        NAMED_MAP.put(name.toLowerCase(Locale.ROOT), c);
        return c;
    }

    public static boolean validate(String str) {
        return NAMED_MAP.containsKey(str.toLowerCase(Locale.ROOT)) || PATTERN_HEX_CODE.matcher(str).matches();
    }

    public static String format(int color) {
        return String.format(color > 0xFFFFFF ? "#%08X" : "#%06X", color);
    }

    private static RGB parse(String str) {
        if (NAMED_MAP.containsKey(str = str.toLowerCase(Locale.ROOT))) {
            return NAMED_MAP.get(str);
        }
        str = PATTERN_LEADING_JUNK.matcher(str).replaceFirst("");
        int color = UnsignedInts.parseUnsignedInt((String)str, (int)16);
        return new RGB(color);
    }

    public static RGB tryParse(String str, RGB defaultValue) {
        if (!RGB.validate(str)) {
            return defaultValue;
        }
        return RGB.parse(str);
    }
}

