/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.gadgetry.transmission.tile;

import epicsquid.gadgetry.core.lib.fluid.ExtendedFluidTank;
import epicsquid.gadgetry.core.lib.tile.CableNetwork;
import epicsquid.gadgetry.core.lib.tile.CableWorldData;
import epicsquid.gadgetry.core.lib.tile.TileCable;
import epicsquid.gadgetry.core.lib.tile.TileModular;
import epicsquid.gadgetry.core.lib.tile.module.FaceConfig;
import epicsquid.gadgetry.core.lib.tile.module.Module;
import epicsquid.gadgetry.core.lib.tile.module.ModuleFluid;
import epicsquid.gadgetry.core.predicates.PredicateTrue;
import epicsquid.gadgetry.transmission.tile.FluidCableNetwork;
import java.util.function.Predicate;
import net.minecraftforge.fluids.FluidStack;

public class TileFluidPipe
extends TileCable {
    public static final String FLUID = "fluid";

    public TileFluidPipe() {
        super(FLUID);
        this.addModule((Module)new ModuleFluidPipe(FLUID, (TileModular)this, 125));
        this.config.setAllIO(FaceConfig.FaceIO.NEUTRAL);
        this.config.setAllModules(FLUID);
    }

    public CableNetwork constructNetwork(CableWorldData data) {
        return new FluidCableNetwork(data);
    }

    public class ModuleFluidPipe
    extends ModuleFluid {
        public ModuleFluidPipe(String name, TileModular tile, final int giveLimit) {
            super(name, tile, giveLimit);
            this.addTank(new ExtendedFluidTank(125, (Predicate)new PredicateTrue(), true){

                public int fill(FluidStack amount, boolean doFill) {
                    if (!(TileFluidPipe.this.network instanceof FluidCableNetwork)) {
                        return 0;
                    }
                    FluidCableNetwork n = (FluidCableNetwork)TileFluidPipe.this.network;
                    if (n.canInsert(amount)) {
                        if (n.fluid == null) {
                            int sent = Math.min(n.sharedCapacity, Math.min(giveLimit, amount.amount));
                            if (doFill) {
                                n.fluid = new FluidStack(amount.getFluid(), sent);
                            }
                            return sent;
                        }
                        int oldAmount = n.fluid.amount;
                        int newAmount = Math.min(n.sharedCapacity, n.fluid.amount + Math.min(giveLimit, amount.amount));
                        int sent = newAmount - oldAmount;
                        if (doFill) {
                            n.fluid.amount += sent;
                        }
                        return sent;
                    }
                    return 0;
                }
            });
        }
    }
}

