/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.gadgetry.transmission.tile;

import epicsquid.gadgetry.core.EventManager;
import epicsquid.gadgetry.core.block.BlockTEFacing;
import epicsquid.gadgetry.core.lib.fluid.ExtendedFluidTank;
import epicsquid.gadgetry.core.lib.tile.TileModular;
import epicsquid.gadgetry.core.lib.tile.module.FaceConfig;
import epicsquid.gadgetry.core.lib.tile.module.Module;
import epicsquid.gadgetry.core.lib.tile.module.ModuleFluid;
import epicsquid.gadgetry.core.lib.tile.module.ModuleInventory;
import epicsquid.gadgetry.core.predicates.PredicateTrue;
import java.util.function.Predicate;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileFluidIO
extends TileModular
implements ITickable {
    public static final String TANK = "tank";
    public static final String INVENTORY = "inventory";
    public EnumFacing face = null;

    public TileFluidIO() {
        this.addModule((Module)new ModuleFluid(TANK, (TileModular)this, 125).addTank(new ExtendedFluidTank(2000, (Predicate)new PredicateTrue(), true){

            public int fill(FluidStack stack, boolean simulate) {
                if (stack != null) {
                    int i;
                    ModuleInventory minv;
                    ModuleInventory inv = minv = (ModuleInventory)TileFluidIO.this.modules.get(TileFluidIO.INVENTORY);
                    boolean filtered = false;
                    for (i = 0; i < 4; ++i) {
                        if (inv.func_70301_a(i).func_190926_b()) continue;
                        filtered = true;
                    }
                    if (filtered) {
                        for (i = 0; i < 4; ++i) {
                            FluidStack t;
                            ItemStack s = inv.func_70301_a(i);
                            Fluid f = null;
                            if (s.func_77973_b() == Items.field_151131_as) {
                                f = FluidRegistry.WATER;
                            }
                            if (s.func_77973_b() == Items.field_151129_at) {
                                f = FluidRegistry.LAVA;
                            }
                            if (s.func_77973_b() instanceof UniversalBucket && (t = ((UniversalBucket)s.func_77973_b()).getFluid(s)) != null) {
                                f = t.getFluid();
                            }
                            if (f != stack.getFluid()) continue;
                            filtered = false;
                        }
                    }
                    if (!filtered) {
                        TileFluidIO.this.func_70296_d();
                        return super.fill(stack, simulate);
                    }
                    return 0;
                }
                return 0;
            }
        }));
        this.addModule((Module)new ModuleInventory(INVENTORY, (TileModular)this, 4, "item_io", new int[0], new int[0]).setSlotPredicate(0, (Predicate)new PredicateTrue()).setSlotPredicate(1, (Predicate)new PredicateTrue()).setSlotPredicate(2, (Predicate)new PredicateTrue()).setSlotPredicate(3, (Predicate)new PredicateTrue()));
        this.canModifyIO = false;
        this.config.setAllIO(FaceConfig.FaceIO.NEUTRAL);
        this.config.setAllModules(TANK);
    }

    public void func_73660_a() {
        if (this.face == null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.face = (EnumFacing)state.func_177229_b((IProperty)BlockTEFacing.facing);
            this.config.setIO(this.face, FaceConfig.FaceIO.OUT);
            this.config.setIO(this.face.func_176734_d(), FaceConfig.FaceIO.IN);
            this.func_70296_d();
        }
        if (!this.field_145850_b.field_72995_K) {
            TileEntity t;
            ModuleFluid tank = (ModuleFluid)this.modules.get(TANK);
            FluidStack stack = ((ExtendedFluidTank)tank.tanks.get(0)).getFluid();
            if ((stack == null || stack != null && stack.amount < ((ExtendedFluidTank)tank.tanks.get(0)).getCapacity()) && (t = this.field_145850_b.func_175625_s(this.func_174877_v().func_177967_a(this.face, -1))) != null && t.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.face)) {
                IFluidTankProperties[] tanks;
                IFluidHandler handler = (IFluidHandler)t.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.face);
                for (IFluidTankProperties p : tanks = handler.getTankProperties()) {
                    if (p.getContents() == null) continue;
                    FluidStack s = p.getContents().copy();
                    s.amount = Math.max(s.amount, tank.receiveLimit);
                    FluidStack drained = handler.drain(s, true);
                    if (drained == null || drained.amount <= 0) continue;
                    ((ExtendedFluidTank)tank.tanks.get(0)).fill(drained, true);
                    handler.drain(drained, true);
                    this.func_70296_d();
                    t.func_70296_d();
                    EventManager.markForUpdate((BlockPos)t.func_174877_v(), (TileEntity)t);
                    break;
                }
            }
        }
        for (Module m : this.modules.values()) {
            m.onUpdate((TileModular)this);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("face")) {
            this.face = EnumFacing.func_82600_a((int)nbt.func_74762_e("face"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.face != null) {
            nbt.func_74768_a("face", this.face.func_176745_a());
        }
        return nbt;
    }
}

