/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.gadgetry.transmission.tile;

import epicsquid.gadgetry.core.lib.tile.CableNetwork;
import epicsquid.gadgetry.core.lib.tile.CableWorldData;
import epicsquid.gadgetry.core.lib.tile.TileCable;
import epicsquid.gadgetry.core.lib.tile.TileModular;
import epicsquid.gadgetry.core.lib.tile.module.FaceConfig;
import epicsquid.gadgetry.core.lib.tile.module.Module;
import epicsquid.gadgetry.core.lib.tile.module.ModuleEnergy;
import epicsquid.gadgetry.transmission.tile.EnergyCableNetwork;
import net.minecraftforge.energy.EnergyStorage;

public class TileEnergyCable
extends TileCable {
    public static final String ENERGY = "energy";

    public TileEnergyCable() {
        super(ENERGY);
        this.addModule((Module)new ModuleEnergyCable(ENERGY, (TileModular)this, 1600, 1600, 1600));
        this.config.setAllIO(FaceConfig.FaceIO.NEUTRAL);
        this.config.setAllModules(ENERGY);
    }

    public CableNetwork constructNetwork(CableWorldData data) {
        return new EnergyCableNetwork(data);
    }

    public class ModuleEnergyCable
    extends ModuleEnergy {
        public ModuleEnergyCable(String name, TileModular tile, int capacity, int receiveLimit, int giveLimit) {
            super(name, tile, capacity, receiveLimit, giveLimit);
        }

        public EnergyStorage constructBattery(int capacity, int maxIn, int maxOut, int energy) {
            return new EnergyStorage(capacity, maxIn, maxOut, energy){

                public int receiveEnergy(int maxReceive, boolean simulate) {
                    if (!(TileEnergyCable.this.network instanceof EnergyCableNetwork)) {
                        return 0;
                    }
                    EnergyCableNetwork n = (EnergyCableNetwork)TileEnergyCable.this.network;
                    if (n.hasOutputs) {
                        int oldAmount = n.storedPower;
                        int newAmount = Math.min(n.sharedCapacity, n.storedPower + maxReceive);
                        int sent = newAmount - oldAmount;
                        if (!simulate) {
                            n.storedPower += sent;
                        }
                        return sent;
                    }
                    return 0;
                }
            };
        }
    }
}

