/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.gadgetry.transmission.tile;

import akka.japi.Pair;
import epicsquid.gadgetry.core.lib.tile.CableNetwork;
import epicsquid.gadgetry.core.lib.tile.CableWorldData;
import epicsquid.gadgetry.core.lib.tile.TileBase;
import epicsquid.gadgetry.core.lib.tile.TileCable;
import epicsquid.gadgetry.core.lib.tile.module.FaceConfig;
import epicsquid.gadgetry.core.util.InventoryUtil;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemCableNetwork
extends CableNetwork {
    public ArrayList<ItemStack> items = new ArrayList();
    public static final String TYPE_ITEMS = "items";
    int offset = 0;

    public ItemCableNetwork(CableWorldData data) {
        super(data);
        this.type = TYPE_ITEMS;
    }

    public ItemCableNetwork(CableWorldData data, int id) {
        super(data, id);
        this.type = TYPE_ITEMS;
    }

    public boolean needsDistributionTick() {
        return this.items.size() > 0;
    }

    public void distribute() {
        int i;
        boolean doContinue = true;
        for (i = 0; i < this.items.size() && doContinue; ++i) {
            ArrayList<Object> outputs = new ArrayList<Object>();
            ArrayList<Object> outputFaces = new ArrayList<Object>();
            for (Pair p : this.connections) {
                if (!((TileEntity)p.first()).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (EnumFacing)p.second())) continue;
                IItemHandler h = (IItemHandler)((TileEntity)p.first()).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (EnumFacing)p.second());
                int insertable = InventoryUtil.attemptInsert((ItemStack)this.items.get(i).func_77946_l(), (IItemHandler)h, (boolean)true);
                if (insertable <= 0) continue;
                outputs.add(p.first());
                outputFaces.add(p.second());
            }
            if (outputs.size() <= 0) continue;
            doContinue = false;
            int toEach = this.items.get(i).func_190916_E() / outputs.size();
            int remainder = this.items.get(i).func_190916_E() - toEach * outputs.size();
            for (int j = 0; j < outputs.size(); ++j) {
                int fixedIndex = (j + this.offset) % outputs.size();
                IItemHandler e = (IItemHandler)((TileEntity)outputs.get(fixedIndex)).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (EnumFacing)outputFaces.get(fixedIndex));
                int toSend = toEach + (j < remainder ? 1 : 0);
                ItemStack stack = this.items.get(i).func_77946_l();
                stack.func_190920_e(toSend);
                int sent = InventoryUtil.attemptInsert((ItemStack)stack.func_77946_l(), (IItemHandler)e, (boolean)true);
                if (sent <= 0) continue;
                InventoryUtil.attemptInsert((ItemStack)stack.func_77946_l(), (IItemHandler)e, (boolean)false);
                stack.func_190918_g(sent);
                this.items.get(i).func_190918_g(sent);
                ((TileEntity)outputs.get(fixedIndex)).func_70296_d();
                this.data.func_76185_a();
            }
        }
        for (i = 0; i < this.items.size(); ++i) {
            if (!this.items.get(i).func_190926_b()) continue;
            this.items.remove(i);
            i = Math.max(0, i - 1);
            this.data.func_76185_a();
        }
        ++this.offset;
    }

    public int canInsert(ItemStack s) {
        boolean counter = false;
        if (s.func_190926_b()) {
            return 0;
        }
        int amount = 0;
        for (Pair p : this.connections) {
            IItemHandler handler;
            int insertable;
            if (p.first() == null || !((TileEntity)p.first()).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (EnumFacing)p.second()) || (insertable = InventoryUtil.attemptInsert((ItemStack)s, (IItemHandler)(handler = (IItemHandler)((TileEntity)p.first()).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (EnumFacing)p.second())), (boolean)true)) <= 0) continue;
            amount += insertable;
        }
        return Math.min(s.func_190916_E(), amount);
    }

    public void processUpdateFor(TileCable c) {
        for (EnumFacing f : EnumFacing.values()) {
            TileEntity t2;
            String s;
            if (c.config.ioConfig.get(f) == FaceConfig.FaceIO.NEUTRAL || (s = TileBase.getTileName((t2 = c.func_145831_w().func_175625_s(c.func_174877_v().func_177972_a(f))).getClass())).length() >= 14 && s.substring(0, 14).equalsIgnoreCase("tile_duct_item") || t2 == null || t2.func_145831_w().func_175623_d(t2.func_174877_v()) || this.cables.contains(t2.func_174877_v())) continue;
            this.connections.add(new Pair((Object)t2, (Object)f.func_176734_d()));
        }
    }

    public ArrayList<ItemStack> getItems() {
        return this.items;
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b(TYPE_ITEMS)) {
            NBTTagList items = tag.func_150295_c(TYPE_ITEMS, 10);
            for (int i = 0; i < items.func_74745_c(); ++i) {
                this.items.add(new ItemStack(items.func_150305_b(i)));
            }
        }
        this.offset = tag.func_74762_e("offset");
        super.readFromNBT(tag);
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = super.writeToNBT();
        if (this.items.size() > 0) {
            NBTTagList itemlist = new NBTTagList();
            for (ItemStack s : this.items) {
                itemlist.func_74742_a((NBTBase)s.func_77955_b(new NBTTagCompound()));
            }
        }
        tag.func_74768_a("offset", this.offset);
        return tag;
    }
}

