/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.gadgetry.transmission.tile;

import akka.japi.Pair;
import epicsquid.gadgetry.core.lib.tile.CableNetwork;
import epicsquid.gadgetry.core.lib.tile.CableWorldData;
import epicsquid.gadgetry.core.lib.tile.TileCable;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidCableNetwork
extends CableNetwork {
    public FluidStack fluid = null;
    public int sharedCapacity = 0;
    public static final String TYPE_FLUID = "fluid";

    public FluidCableNetwork(CableWorldData data) {
        super(data);
        this.type = TYPE_FLUID;
    }

    public FluidCableNetwork(CableWorldData data, int id) {
        super(data, id);
        this.type = TYPE_FLUID;
    }

    public boolean needsDistributionTick() {
        return this.fluid != null;
    }

    public void processUpdateFor(TileCable t) {
        super.processUpdateFor(t);
        this.sharedCapacity = 16000;
    }

    public void distribute() {
        ArrayList<Object> outputs = new ArrayList<Object>();
        ArrayList<Object> outputFaces = new ArrayList<Object>();
        for (Pair p : this.connections) {
            if (!((TileEntity)p.first()).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, (EnumFacing)p.second()) || ((IFluidHandler)((TileEntity)p.first()).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, (EnumFacing)p.second())).fill(this.fluid.copy(), false) <= 0) continue;
            outputs.add(p.first());
            outputFaces.add(p.second());
        }
        if (outputs.size() > 0) {
            int toEach = this.fluid.amount / outputs.size();
            int remainder = this.fluid.amount - toEach * outputs.size();
            for (int i = 0; i < outputs.size(); ++i) {
                IFluidHandler e = (IFluidHandler)((TileEntity)outputs.get(i)).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, (EnumFacing)outputFaces.get(i));
                int toSend = toEach + (i < remainder ? 1 : 0);
                int sent = e.fill(new FluidStack(this.fluid.getFluid(), toSend), false);
                if (sent <= 0) continue;
                e.fill(new FluidStack(this.fluid.getFluid(), sent), true);
                this.fluid.amount -= sent;
                ((TileEntity)outputs.get(i)).func_70296_d();
                this.data.func_76185_a();
            }
        }
        if (this.fluid.amount == 0) {
            this.fluid = null;
        }
    }

    public boolean canInsert(FluidStack s) {
        int counter = 0;
        if (this.fluid != null && s != null && this.fluid.getFluid() != s.getFluid()) {
            return false;
        }
        for (Pair p : this.connections) {
            if (p.first() == null || !((TileEntity)p.first()).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, (EnumFacing)p.second()) || ((IFluidHandler)((TileEntity)p.first()).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, (EnumFacing)p.second())).fill(s.copy(), false) <= 0) continue;
            ++counter;
        }
        return counter > 0;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public int getSharedCapacity() {
        return this.sharedCapacity;
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b(TYPE_FLUID)) {
            this.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l(TYPE_FLUID));
        }
        this.sharedCapacity = tag.func_74762_e("capacity");
        super.readFromNBT(tag);
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = super.writeToNBT();
        if (this.fluid != null) {
            tag.func_74782_a(TYPE_FLUID, (NBTBase)this.fluid.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74768_a("capacity", this.sharedCapacity);
        return tag;
    }
}

