/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.gadgetry.transmission.tile;

import akka.japi.Pair;
import epicsquid.gadgetry.core.lib.tile.CableNetwork;
import epicsquid.gadgetry.core.lib.tile.CableWorldData;
import epicsquid.gadgetry.core.lib.tile.TileCable;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyCableNetwork
extends CableNetwork {
    public int storedPower = 0;
    public int sharedCapacity = 0;
    public boolean hasOutputs = false;
    public static final String TYPE_ENERGY = "energy";

    public EnergyCableNetwork(CableWorldData data) {
        super(data);
        this.type = TYPE_ENERGY;
    }

    public EnergyCableNetwork(CableWorldData data, int id) {
        super(data, id);
        this.type = TYPE_ENERGY;
    }

    public boolean needsDistributionTick() {
        this.hasOutputs = false;
        for (Pair p : this.connections) {
            if (!((TileEntity)p.first()).hasCapability(CapabilityEnergy.ENERGY, (EnumFacing)p.second()) || !((IEnergyStorage)((TileEntity)p.first()).getCapability(CapabilityEnergy.ENERGY, (EnumFacing)p.second())).canReceive() || ((IEnergyStorage)((TileEntity)p.first()).getCapability(CapabilityEnergy.ENERGY, (EnumFacing)p.second())).receiveEnergy(1, true) <= 0) continue;
            this.hasOutputs = true;
        }
        return this.storedPower > 0;
    }

    public void processUpdateFor(TileCable t) {
        super.processUpdateFor(t);
        this.sharedCapacity = 160000;
    }

    public void distribute() {
        ArrayList<Object> outputs = new ArrayList<Object>();
        ArrayList<Object> outputFaces = new ArrayList<Object>();
        for (Pair p : this.connections) {
            if (!((TileEntity)p.first()).hasCapability(CapabilityEnergy.ENERGY, (EnumFacing)p.second()) || !((IEnergyStorage)((TileEntity)p.first()).getCapability(CapabilityEnergy.ENERGY, (EnumFacing)p.second())).canReceive() || ((IEnergyStorage)((TileEntity)p.first()).getCapability(CapabilityEnergy.ENERGY, (EnumFacing)p.second())).receiveEnergy(1, true) <= 0) continue;
            outputs.add(p.first());
            outputFaces.add(p.second());
        }
        if (outputs.size() > 0) {
            int toEach = this.storedPower / outputs.size();
            int remainder = this.storedPower - toEach * outputs.size();
            for (int i = 0; i < outputs.size(); ++i) {
                int toSend;
                IEnergyStorage e = (IEnergyStorage)((TileEntity)outputs.get(i)).getCapability(CapabilityEnergy.ENERGY, (EnumFacing)outputFaces.get(i));
                int sent = e.receiveEnergy(toSend = toEach + (i < remainder ? 1 : 0), true);
                if (sent <= 0) continue;
                e.receiveEnergy(sent, false);
                this.storedPower -= sent;
                ((TileEntity)outputs.get(i)).func_70296_d();
                this.data.func_76185_a();
            }
        }
    }

    public int getSharedPower() {
        return this.storedPower;
    }

    public int getSharedCapacity() {
        return this.sharedCapacity;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.storedPower = tag.func_74762_e("power");
        this.sharedCapacity = tag.func_74762_e("capacity");
        super.readFromNBT(tag);
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = super.writeToNBT();
        tag.func_74768_a("power", this.storedPower);
        tag.func_74768_a("capacity", this.sharedCapacity);
        return tag;
    }
}

