/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.fluidfunnel.block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import party.lemons.fluidfunnel.FluidFunnel;
import party.lemons.fluidfunnel.block.te.TileEntityFunnel;
import party.lemons.fluidfunnel.message.MessageRemoveTile;

public class BlockFunnel
extends Block
implements ITileEntityProvider {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", p_apply_1_ -> p_apply_1_ != EnumFacing.UP);
    public static final PropertyBool ENABLED = PropertyBool.func_177716_a((String)"enabled");
    protected static final AxisAlignedBB BASE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);
    private Map<EnumFacing, ArrayList<AxisAlignedBB>> blockBounds;

    public BlockFunnel() {
        super(Material.field_151573_f, MapColor.field_151670_w);
        this.func_149647_a(CreativeTabs.field_78026_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(3.0f);
        this.func_149752_b(8.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.blockBounds = new HashMap<EnumFacing, ArrayList<AxisAlignedBB>>();
        for (EnumFacing facing : EnumFacing.values()) {
            if (facing == EnumFacing.UP) continue;
            ArrayList<AxisAlignedBB> bounds = new ArrayList<AxisAlignedBB>();
            bounds.add(new AxisAlignedBB(0.0, 0.625, 0.0, 1.0, 1.0, 1.0));
            bounds.add(new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.625, 0.75));
            this.blockBounds.put(facing, bounds);
        }
        this.blockBounds.get(EnumFacing.DOWN).add(new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.25, 0.625));
        this.blockBounds.get(EnumFacing.NORTH).add(new AxisAlignedBB(0.375, 0.25, 0.0, 0.625, 0.5, 0.25));
        this.blockBounds.get(EnumFacing.SOUTH).add(new AxisAlignedBB(0.375, 0.25, 0.75, 0.625, 0.5, 1.0));
        this.blockBounds.get(EnumFacing.WEST).add(new AxisAlignedBB(0.0, 0.25, 0.375, 0.25, 0.5, 0.625));
        this.blockBounds.get(EnumFacing.EAST).add(new AxisAlignedBB(0.75, 0.25, 0.375, 1.0, 0.5, 0.625));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return !player.func_70093_af() && FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (World)world, (BlockPos)pos, (EnumFacing)side);
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityFunnel();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.updateState(worldIn, pos, state);
    }

    private void updateState(World worldIn, BlockPos pos, IBlockState state) {
        boolean flag;
        boolean bl = flag = !worldIn.func_175640_z(pos);
        if (flag != (Boolean)state.func_177229_b((IProperty)ENABLED)) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(flag)));
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile != null) {
            worldIn.func_175713_t(pos);
            FluidFunnel.NETWORK.sendToAllAround((IMessage)new MessageRemoveTile(tile.func_174877_v()), new NetworkRegistry.TargetPoint(tile.func_145831_w().field_73011_w.getDimension(), (double)tile.func_174877_v().func_177958_n(), (double)tile.func_174877_v().func_177956_o(), (double)tile.func_174877_v().func_177952_p(), 128.0));
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public static EnumFacing getFacing(int meta) {
        return EnumFacing.func_82600_a((int)(meta & 7));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public static boolean isEnabled(int meta) {
        return (meta & 8) != 8;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)BlockFunnel.getFacing(meta)).func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(BlockFunnel.isEnabled(meta)));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        if (!((Boolean)state.func_177229_b((IProperty)ENABLED)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ENABLED});
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.UP ? BlockFaceShape.BOWL : BlockFaceShape.UNDEFINED;
    }

    public boolean func_185481_k(IBlockState state) {
        return true;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.updateState(worldIn, pos, state);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        BlockFunnel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BASE_AABB);
        BlockFunnel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_AABB);
        BlockFunnel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_AABB);
        BlockFunnel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_AABB);
        BlockFunnel.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_AABB);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing enumfacing = facing.func_176734_d();
        if (enumfacing == EnumFacing.UP) {
            enumfacing = EnumFacing.DOWN;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(true));
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)FACING);
        for (AxisAlignedBB bb : this.blockBounds.get(facing)) {
            RayTraceResult res = this.func_185503_a(pos, start, end, bb);
            if (res == null) continue;
            return super.func_180636_a(blockState, worldIn, pos, start, end);
        }
        return null;
    }
}

