/*
 * Decompiled with CFR 0.152.
 */
package com.shblock.integratedproxy.tileentity;

import com.shblock.integratedproxy.IPRegistryEntries;
import com.shblock.integratedproxy.IntegratedProxy;
import com.shblock.integratedproxy.block.BlockAccessProxy;
import com.shblock.integratedproxy.block.BlockAccessProxyConfig;
import com.shblock.integratedproxy.id_network.AccessProxyNetworkElement;
import com.shblock.integratedproxy.inventory.container.ContainerAccessProxy;
import com.shblock.integratedproxy.network.packet.RemoveProxyRenderPacket;
import com.shblock.integratedproxy.network.packet.UpdateProxyDisableRenderPacket;
import com.shblock.integratedproxy.network.packet.UpdateProxyDisplayRotationPacket;
import com.shblock.integratedproxy.network.packet.UpdateProxyDisplayValuePacket;
import com.shblock.integratedproxy.network.packet.UpdateProxyRenderPacket;
import com.shblock.integratedproxy.storage.AccessProxyCollection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.integrateddynamics.api.block.IDynamicRedstone;
import org.cyclops.integrateddynamics.api.block.IVariableContainer;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkEventListener;
import org.cyclops.integrateddynamics.api.network.event.INetworkEvent;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.capability.variablecontainer.VariableContainerConfig;
import org.cyclops.integrateddynamics.capability.variablecontainer.VariableContainerDefault;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityCableConnectableInventory;
import org.cyclops.integrateddynamics.core.evaluate.InventoryVariableEvaluator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.network.event.NetworkElementAddEvent;
import org.cyclops.integrateddynamics.core.network.event.NetworkElementRemoveEvent;
import org.cyclops.integrateddynamics.core.network.event.VariableContentsUpdatedEvent;
import org.cyclops.integrateddynamics.item.ItemVariable;
import org.cyclops.integrateddynamics.part.PartTypeBlockReader;
import org.cyclops.integratedtunnels.core.part.PartTypeInterfacePositionedAddon;

public class TileAccessProxy
extends BlockEntityCableConnectableInventory
implements IDirtyMarkListener,
INetworkEventListener<AccessProxyNetworkElement>,
MenuProvider {
    public static final int SLOT_X = 0;
    public static final int SLOT_Y = 1;
    public static final int SLOT_Z = 2;
    public static final int SLOT_DISPLAY = 3;
    public final InventoryVariableEvaluator<ValueTypeInteger.ValueInteger> evaluator_x;
    public final InventoryVariableEvaluator<ValueTypeInteger.ValueInteger> evaluator_y;
    public final InventoryVariableEvaluator<ValueTypeInteger.ValueInteger> evaluator_z;
    public final InventoryVariableEvaluator<IValue> evaluator_display;
    private IValue display_value;
    private final IVariableContainer variableContainer;
    private boolean shouldSendUpdateEvent = false;
    public DimPos target;
    public int pos_mode = 0;
    public int[] display_rotations = new int[]{0, 0, 0, 0, 0, 0};
    private int[] redstone_powers = new int[]{0, 0, 0, 0, 0, 0};
    private int[] strong_powers = new int[]{0, 0, 0, 0, 0, 0};
    public boolean disable_render = false;

    public TileAccessProxy(BlockPos blockPos, BlockState blockState) {
        super(IPRegistryEntries.TILE_ACCESS_PROXY, blockPos, blockState, 4, 1);
        this.getInventory().addDirtyMarkListener((IDirtyMarkListener)this);
        this.addCapabilityInternal(NetworkElementProviderConfig.CAPABILITY, LazyOptional.of(() -> new NetworkElementProviderSingleton(){

            public INetworkElement createNetworkElement(Level world, BlockPos blockPos) {
                return new AccessProxyNetworkElement(DimPos.of((Level)world, (BlockPos)blockPos));
            }
        }));
        this.variableContainer = new VariableContainerDefault();
        this.addCapabilityInternal(VariableContainerConfig.CAPABILITY, LazyOptional.of(() -> this.variableContainer));
        this.evaluator_x = new InventoryVariableEvaluator((Container)this.getInventory(), 0, (IValueType)ValueTypes.INTEGER);
        this.evaluator_y = new InventoryVariableEvaluator((Container)this.getInventory(), 1, (IValueType)ValueTypes.INTEGER);
        this.evaluator_z = new InventoryVariableEvaluator((Container)this.getInventory(), 2, (IValueType)ValueTypes.INTEGER);
        this.evaluator_display = new InventoryVariableEvaluator((Container)this.getInventory(), 3, (IValueType)ValueTypes.CATEGORY_ANY);
    }

    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new SimpleInventory(inventorySize, stackSize){

            public boolean m_7013_(int i, ItemStack stack) {
                return super.m_7013_(i, stack) && stack.m_41720_() instanceof ItemVariable;
            }

            public boolean m_7155_(int index, ItemStack itemStackIn, @Nullable Direction direction) {
                return false;
            }

            public boolean m_7157_(int index, ItemStack stack, Direction direction) {
                return false;
            }

            public int[] m_7071_(Direction side) {
                return new int[0];
            }

            public IItemHandler getItemHandler() {
                return new InvWrapper((Container)this){

                    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                        return stack;
                    }

                    public ItemStack extractItem(int slot, int amount, boolean simulate) {
                        return ItemStack.f_41583_;
                    }
                };
            }
        };
    }

    public CompoundTag writeToItemStack(CompoundTag tag) {
        return new CompoundTag();
    }

    public CompoundTag save(CompoundTag tag) {
        tag = super.save(tag);
        tag.m_128405_("pos_mode", this.pos_mode);
        NBTClassType.writeNbt(List.class, (String)"errors_x", (Object)this.evaluator_x.getErrors(), (CompoundTag)tag);
        NBTClassType.writeNbt(List.class, (String)"errors_y", (Object)this.evaluator_y.getErrors(), (CompoundTag)tag);
        NBTClassType.writeNbt(List.class, (String)"errors_z", (Object)this.evaluator_z.getErrors(), (CompoundTag)tag);
        NBTClassType.writeNbt(List.class, (String)"errors_display", (Object)this.evaluator_display.getErrors(), (CompoundTag)tag);
        tag.m_128385_("display_rotations", this.display_rotations);
        if (this.getDisplayValue() != null) {
            tag.m_128365_("displayValue", (Tag)ValueHelpers.serialize((IValue)this.getDisplayValue()));
        }
        tag.m_128385_("rs_power", this.redstone_powers);
        tag.m_128385_("strong_power", this.strong_powers);
        tag.m_128379_("disable_render", this.disable_render);
        return tag;
    }

    public void read(CompoundTag tag) {
        super.read(tag);
        this.pos_mode = tag.m_128451_("pos_mode");
        this.evaluator_x.setErrors((List)NBTClassType.readNbt(List.class, (String)"errors_x", (CompoundTag)tag));
        this.evaluator_y.setErrors((List)NBTClassType.readNbt(List.class, (String)"errors_y", (CompoundTag)tag));
        this.evaluator_z.setErrors((List)NBTClassType.readNbt(List.class, (String)"errors_z", (CompoundTag)tag));
        this.evaluator_display.setErrors((List)NBTClassType.readNbt(List.class, (String)"errors_display", (CompoundTag)tag));
        this.display_rotations = tag.m_128465_("display_rotations");
        if (tag.m_128425_("displayValue", 10)) {
            this.setDisplayValue(ValueHelpers.deserialize((CompoundTag)tag.m_128469_("displayValue")));
        } else {
            this.setDisplayValue(null);
        }
        if (tag.m_128441_("rs_power")) {
            this.redstone_powers = tag.m_128465_("rs_power");
        }
        if (tag.m_128441_("strong_power")) {
            this.strong_powers = tag.m_128465_("strong_power");
        }
        if (tag.m_128441_("disable_render")) {
            this.disable_render = tag.m_128471_("disable_render");
        }
        this.shouldSendUpdateEvent = true;
    }

    public IValue getDisplayValue() {
        return this.display_value;
    }

    public void setDisplayValue(IValue displayValue) {
        this.display_value = displayValue;
    }

    public void rotateDisplayValue(Direction side) {
        int ord;
        int n = ord = side.ordinal();
        this.display_rotations[n] = this.display_rotations[n] + 1;
        if (this.display_rotations[ord] >= 4) {
            this.display_rotations[ord] = 0;
        }
        this.m_6596_();
        IntegratedProxy._instance.getPacketHandler().sendToAll((PacketBase)new UpdateProxyDisplayRotationPacket(DimPos.of((Level)this.f_58857_, (BlockPos)this.f_58858_), this.display_rotations));
    }

    public void changeDisableRender() {
        this.disable_render = !this.disable_render;
        this.m_6596_();
        IntegratedProxy._instance.getPacketHandler().sendToAll((PacketBase)new UpdateProxyDisableRenderPacket(DimPos.of((Level)this.f_58857_, (BlockPos)this.f_58858_), this.disable_render));
    }

    protected void refreshVariables(boolean sendVariablesUpdateEvent) {
        this.evaluator_x.refreshVariable(this.getNetwork(), false);
        this.evaluator_y.refreshVariable(this.getNetwork(), false);
        this.evaluator_z.refreshVariable(this.getNetwork(), false);
        this.evaluator_display.refreshVariable(this.getNetwork(), sendVariablesUpdateEvent);
    }

    public int getVariableIntValue(InventoryVariableEvaluator<ValueTypeInteger.ValueInteger> evaluator) throws EvaluationException {
        return ((ValueTypeInteger.ValueInteger)((ValueTypeInteger.ValueInteger)evaluator.getVariable(this.getNetwork()).getValue()).cast((IValueType)ValueTypes.INTEGER)).getRawValue();
    }

    private boolean isTargetOutOfRange(BlockPos target) {
        if (BlockAccessProxyConfig.range < 0) {
            return false;
        }
        return Math.abs(target.m_123341_() - this.f_58858_.m_123341_()) > BlockAccessProxyConfig.range || Math.abs(target.m_123342_() - this.f_58858_.m_123342_()) > BlockAccessProxyConfig.range || Math.abs(target.m_123343_() - this.f_58858_.m_123343_()) > BlockAccessProxyConfig.range;
    }

    private void updateTarget() {
        if (!this.f_58857_.f_46443_) {
            DimPos old_target = this.target == null ? null : DimPos.of((String)this.target.getLevel(), (BlockPos)this.target.getBlockPos());
            try {
                this.target = this.pos_mode == 1 ? DimPos.of((Level)this.f_58857_, (BlockPos)new BlockPos(this.isVariableAvailable(this.evaluator_x) ? this.getVariableIntValue(this.evaluator_x) : this.f_58858_.m_123341_(), this.isVariableAvailable(this.evaluator_y) ? this.getVariableIntValue(this.evaluator_y) : this.f_58858_.m_123342_(), this.isVariableAvailable(this.evaluator_z) ? this.getVariableIntValue(this.evaluator_z) : this.f_58858_.m_123343_())) : DimPos.of((Level)this.f_58857_, (BlockPos)new BlockPos(this.isVariableAvailable(this.evaluator_x) ? this.getVariableIntValue(this.evaluator_x) + this.f_58858_.m_123341_() : this.f_58858_.m_123341_(), this.isVariableAvailable(this.evaluator_y) ? this.getVariableIntValue(this.evaluator_y) + this.f_58858_.m_123342_() : this.f_58858_.m_123342_(), this.isVariableAvailable(this.evaluator_z) ? this.getVariableIntValue(this.evaluator_z) + this.f_58858_.m_123343_() : this.f_58858_.m_123343_()));
            }
            catch (EvaluationException e) {
                this.target = DimPos.of((Level)this.f_58857_, (BlockPos)this.f_58858_);
            }
            if (this.isTargetOutOfRange(this.target.getBlockPos())) {
                this.target = DimPos.of((Level)this.f_58857_, (BlockPos)this.f_58858_);
            }
            if (!this.target.equals((Object)old_target)) {
                if (old_target != null) {
                    this.notifyTargetChange();
                }
                IntegratedProxy._instance.getPacketHandler().sendToAll((PacketBase)new UpdateProxyRenderPacket(DimPos.of((Level)this.f_58857_, (BlockPos)this.f_58858_), this.target));
                AccessProxyCollection.getInstance(this.f_58857_).set(this.f_58858_, this.target.getBlockPos());
                this.updateTargetBlock();
                if (old_target != null) {
                    this.updateTargetBlock(this.f_58857_, old_target.getBlockPos());
                }
            }
        }
    }

    private boolean isVariableAvailable(InventoryVariableEvaluator<ValueTypeInteger.ValueInteger> evaluator) {
        if (this.getNetwork() == null) {
            return false;
        }
        if (evaluator.getVariable(this.getNetwork()) == null) {
            return false;
        }
        return evaluator.hasVariable() && evaluator.getErrors().isEmpty();
    }

    public boolean variableOk(InventoryVariableEvaluator<IValue> evaluator) {
        if (this.getNetwork() == null) {
            return false;
        }
        if (evaluator.getVariable(this.getNetwork()) == null) {
            return false;
        }
        return evaluator.hasVariable() && evaluator.getErrors().isEmpty();
    }

    public boolean variableIntegerOk(InventoryVariableEvaluator<ValueTypeInteger.ValueInteger> evaluator) {
        if (this.getNetwork() == null) {
            return false;
        }
        if (evaluator.getVariable(this.getNetwork()) == null) {
            return false;
        }
        return evaluator.hasVariable() && evaluator.getVariable(this.getNetwork()).getType() instanceof ValueTypeInteger && evaluator.getErrors().isEmpty();
    }

    public boolean setSideRedstonePower(Direction side, IDynamicRedstone cap) {
        int[] old_strong = (int[])this.strong_powers.clone();
        int[] old_power = (int[])this.redstone_powers.clone();
        if (cap != null) {
            this.redstone_powers[side.m_122411_()] = cap.getRedstoneLevel();
            this.strong_powers[side.m_122411_()] = cap.isDirect() ? cap.getRedstoneLevel() : 0;
        } else {
            this.redstone_powers[side.m_122411_()] = 0;
            this.strong_powers[side.m_122411_()] = 0;
        }
        this.m_6596_();
        return this.redstone_powers != old_power || this.strong_powers != old_strong;
    }

    public int getRedstonePowerForTarget() {
        int power = 0;
        for (int i : this.redstone_powers) {
            power = Math.max(power, i);
        }
        return power;
    }

    public int getStrongPowerForTarget() {
        int power = 0;
        for (int i : this.strong_powers) {
            power = Math.max(power, i);
        }
        return power;
    }

    public void onDirty() {
        if (!this.f_58857_.f_46443_) {
            this.refreshVariables(true);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (!MinecraftHelpers.isClientSideThread()) {
            this.shouldSendUpdateEvent = true;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    public void onChunkUnloaded() {
        this.unRegisterEventHandle();
    }

    public void sendRemoveRenderPacket() {
        if (!this.f_58857_.f_46443_) {
            IntegratedProxy._instance.getPacketHandler().sendToAll((PacketBase)new RemoveProxyRenderPacket(DimPos.of((Level)this.f_58857_, (BlockPos)this.f_58858_)));
        }
    }

    public void unRegisterEventHandle() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    public static void updateTileEntity(Level level, BlockPos pos, BlockState blockState, TileAccessProxy tile) {
        if (tile.shouldSendUpdateEvent && tile.getNetwork() != null) {
            tile.shouldSendUpdateEvent = false;
            tile.refreshVariables(true);
        }
        if (!level.f_46443_) {
            boolean is_dirty = false;
            try {
                IValue value = tile.evaluator_display.getVariable(tile.getNetwork()).getValue();
                if (value != tile.getDisplayValue()) {
                    is_dirty = true;
                }
                tile.setDisplayValue(value);
            }
            catch (NullPointerException | EvaluationException e) {
                if (tile.display_value != null) {
                    is_dirty = true;
                }
                tile.setDisplayValue(null);
            }
            if (is_dirty) {
                tile.m_6596_();
                IntegratedProxy._instance.getPacketHandler().sendToAll((PacketBase)new UpdateProxyDisplayValuePacket(DimPos.of((Level)tile.f_58857_, (BlockPos)tile.f_58858_), tile.getDisplayValue()));
            }
            tile.updateTarget();
        }
    }

    public void afterNetworkReAlive() {
        this.refreshVariables(true);
        this.updateTarget();
    }

    public boolean hasEventSubscriptions() {
        return true;
    }

    public Set<Class<? extends INetworkEvent>> getSubscribedEvents() {
        HashSet<Class<? extends INetworkEvent>> set = new HashSet<Class<? extends INetworkEvent>>();
        set.add(VariableContentsUpdatedEvent.class);
        set.add(NetworkElementAddEvent.class);
        set.add(NetworkElementRemoveEvent.class);
        return set;
    }

    public void onEvent(INetworkEvent event, AccessProxyNetworkElement networkElement) {
        this.refreshVariables(false);
        this.updateTarget();
        this.sendUpdate();
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (this.m_58901_()) {
            this.unRegisterEventHandle();
            return;
        }
        try {
            if (!event.getPlayer().f_19853_.f_46443_) {
                IntegratedProxy._instance.getPacketHandler().sendToPlayer((PacketBase)new UpdateProxyRenderPacket(DimPos.of((Level)this.f_58857_, (BlockPos)this.f_58858_), this.target), (ServerPlayer)event.getPlayer());
                IntegratedProxy._instance.getPacketHandler().sendToPlayer((PacketBase)new UpdateProxyDisplayValuePacket(DimPos.of((Level)this.f_58857_, (BlockPos)this.f_58858_), this.getDisplayValue()), (ServerPlayer)event.getPlayer());
                IntegratedProxy._instance.getPacketHandler().sendToPlayer((PacketBase)new UpdateProxyDisplayRotationPacket(DimPos.of((Level)this.f_58857_, (BlockPos)this.f_58858_), this.display_rotations), (ServerPlayer)event.getPlayer());
                IntegratedProxy._instance.getPacketHandler().sendToPlayer((PacketBase)new UpdateProxyDisableRenderPacket(DimPos.of((Level)this.f_58857_, (BlockPos)this.f_58858_), this.disable_render), (ServerPlayer)event.getPlayer());
            }
        }
        catch (NullPointerException e) {
            IntegratedProxy.clog(org.apache.logging.log4j.Level.ERROR, "Failed to sync proxy render data with client!");
        }
    }

    public static void updateAfterBlockDestroy(Level world, BlockPos pos) {
        for (Direction offset : Direction.values()) {
            world.m_46586_(pos.m_141952_(offset.m_122436_()), (Block)IPRegistryEntries.BLOCK_ACCESS_PROXY, pos);
        }
    }

    private void notifyTargetChange() {
        try {
            if (this.m_58901_()) {
                this.unRegisterEventHandle();
                return;
            }
            for (Direction offset : Direction.values()) {
                this.f_58857_.m_46586_(this.f_58858_.m_141952_(offset.m_122436_()), this.m_58900_().m_60734_(), this.f_58858_);
            }
            this.refreshFacePartNetwork();
        }
        catch (NullPointerException e) {
            IntegratedProxy.clog(org.apache.logging.log4j.Level.WARN, "NullPointerException at onTargetChanged!   " + this.target.toString() + "   " + this.f_58857_.toString());
        }
    }

    public void refreshFacePartNetwork() {
        TileAccessProxy.refreshFacePartNetwork(this.f_58857_, this.f_58858_);
    }

    public static void refreshFacePartNetwork(Level world, BlockPos pos) {
        for (Direction offset : Direction.values()) {
            try {
                PartHelpers.PartStateHolder partStateHolder;
                INetwork network = (INetwork)NetworkHelpers.getNetwork((BlockGetter)world, (BlockPos)pos.m_141952_(offset.m_122436_()), null).orElse(null);
                if (network != null && !network.isKilled() || (partStateHolder = PartHelpers.getPart((PartPos)PartPos.of((Level)world, (BlockPos)pos.m_141952_(offset.m_122436_()), (Direction)offset.m_122424_()))) == null) continue;
                if (ModList.get().isLoaded("integratedtunnels") && partStateHolder.getPart() instanceof PartTypeInterfacePositionedAddon) {
                    NetworkHelpers.initNetwork((Level)world, (BlockPos)pos.m_141952_(offset.m_122436_()), null);
                }
                if (!(partStateHolder.getPart() instanceof PartTypeBlockReader)) continue;
                NetworkHelpers.initNetwork((Level)world, (BlockPos)pos.m_141952_(offset.m_122436_()), null);
            }
            catch (NullPointerException | ConcurrentModificationException e) {
                IntegratedProxy.clog(org.apache.logging.log4j.Level.WARN, "refreshFacePartNetwork failed");
                e.printStackTrace();
            }
        }
    }

    public void updateTargetBlock(Level world, BlockPos pos) {
        if (!world.m_46749_(pos)) {
            return;
        }
        for (Direction facing : Direction.values()) {
            world.m_46586_(pos, world.m_8055_(pos).m_60734_(), pos.m_141952_(facing.m_122436_()));
        }
        for (Direction facing : Direction.values()) {
            if (world.m_8055_(pos.m_141952_(facing.m_122436_())).m_60734_() instanceof BlockAccessProxy) continue;
            world.m_46586_(pos.m_141952_(facing.m_122436_()), world.m_8055_(pos.m_141952_(facing.m_122436_())).m_60734_(), pos);
        }
    }

    public void updateTargetBlock() {
        this.updateTargetBlock(this.f_58857_, this.target.getBlockPos());
    }

    public void onTargetChanged(LevelAccessor world, BlockPos pos) {
        if (this.target == null || this.m_58901_() || this.target.getBlockPos() == this.f_58858_) {
            return;
        }
        if (pos.equals((Object)this.target.getBlockPos()) && world.equals(this.f_58857_)) {
            this.notifyTargetChange();
        }
    }

    @SubscribeEvent
    public void onNeighborNotifyEvent(BlockEvent.NeighborNotifyEvent event) {
        if (this.target != null && !this.m_58901_()) {
            if (event.getPos().equals((Object)this.target.getBlockPos()) && event.getWorld().equals(this.f_58857_)) {
                this.onTargetChanged(event.getWorld(), event.getPos());
            }
            for (Direction facing : event.getNotifiedSides()) {
                BlockPos offset_pos = event.getPos().m_141952_(facing.m_122436_());
                if (!offset_pos.equals((Object)this.target.getBlockPos())) continue;
                this.onTargetChanged(event.getWorld(), offset_pos);
            }
        }
    }

    @SubscribeEvent
    public void onCropGrowEvent(BlockEvent.CropGrowEvent.Post event) {
        if (!event.getWorld().m_5776_()) {
            this.onTargetChanged(event.getWorld(), event.getPos());
        }
    }

    @SubscribeEvent
    public void onServerStop(ServerStoppingEvent event) {
        this.unRegisterEventHandle();
    }

    public Component m_5446_() {
        return new TranslatableComponent("tile.blocks.integrated_proxy.access_proxy.name");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerAccessProxy(id, playerInventory, (Container)this.getInventory(), Optional.of(this));
    }
}

