/*
 * Decompiled with CFR 0.152.
 */
package com.shblock.integratedproxy.storage;

import com.shblock.integratedproxy.helper.BlockPosHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class AccessProxyCollection
extends SavedData {
    public static final String NAME = "integrated_proxy_access_proxy_collection";
    private HashMap<BlockPos, BlockPos> map = new HashMap();

    public static AccessProxyCollection getInstance(Level world) {
        DimensionDataStorage storage = ((ServerLevel)world).m_8895_();
        AccessProxyCollection data = (AccessProxyCollection)storage.m_164858_(AccessProxyCollection::load, NAME);
        if (data == null) {
            data = new AccessProxyCollection();
            storage.m_164855_(NAME, (SavedData)data);
        }
        return data;
    }

    public void set(BlockPos proxy, BlockPos target) {
        this.map.put(proxy, target);
        this.m_77762_();
    }

    public void remove(BlockPos proxy) {
        this.map.remove(proxy);
        this.m_77762_();
    }

    public HashSet<BlockPos> getProxiesFromTarget(BlockPos target) {
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        for (Map.Entry<BlockPos, BlockPos> entry : this.map.entrySet()) {
            if (!entry.getValue().equals((Object)target)) continue;
            set.add(entry.getKey());
        }
        return set;
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        ListTag list = new ListTag();
        for (Map.Entry<BlockPos, BlockPos> entry : this.map.entrySet()) {
            list.add((Object)new IntArrayTag(BlockPosHelper.blockPosToSet(entry.getKey())));
            list.add((Object)new IntArrayTag(BlockPosHelper.blockPosToSet(entry.getValue())));
        }
        compound.m_128365_("map", (Tag)list);
        return compound;
    }

    public static AccessProxyCollection load(CompoundTag nbt) {
        AccessProxyCollection collection = new AccessProxyCollection();
        collection.map = new HashMap();
        ListTag list = nbt.m_128437_("map", 11);
        for (int i = 0; i < list.size() / 2; ++i) {
            collection.map.put(BlockPosHelper.setToBlockPos(list.m_128767_(i)), BlockPosHelper.setToBlockPos(list.m_128767_(i + 1)));
        }
        return collection;
    }
}

