/*
 * Decompiled with CFR 0.152.
 */
package com.shblock.integratedproxy.mixin;

import com.shblock.integratedproxy.IntegratedProxy;
import com.shblock.integratedproxy.storage.AccessProxyCollection;
import com.shblock.integratedproxy.tileentity.TileAccessProxy;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={net.minecraft.world.level.Level.class})
public abstract class MixinWorldRedstone {
    @Shadow
    @Nullable
    public abstract MinecraftServer m_142572_();

    @Shadow
    public abstract ResourceKey<net.minecraft.world.level.Level> m_46472_();

    @Shadow
    @Nullable
    public abstract BlockEntity m_7702_(BlockPos var1);

    @Inject(at={@At(value="RETURN")}, method={"getSignal"}, cancellable=true)
    public void getRedstonePower(BlockPos pos, Direction facing, CallbackInfoReturnable<Integer> callback) {
        MinecraftServer server = this.m_142572_();
        if (server == null) {
            return;
        }
        ServerLevel world = server.m_129880_(this.m_46472_());
        if (world == null) {
            return;
        }
        AccessProxyCollection data = AccessProxyCollection.getInstance((net.minecraft.world.level.Level)world);
        HashSet<BlockPos> proxies = data.getProxiesFromTarget(pos.m_141952_(facing.m_122424_().m_122436_()));
        if (!proxies.isEmpty()) {
            int max_power = (Integer)callback.getReturnValue();
            for (BlockPos proxy : proxies) {
                BlockEntity tile = this.m_7702_(proxy);
                if (tile instanceof TileAccessProxy) {
                    max_power = Math.max(max_power, ((TileAccessProxy)tile).getRedstonePowerForTarget());
                    continue;
                }
                data.remove(proxy);
                IntegratedProxy.clog(Level.WARN, "Found a tile that's not AccessProxy in AccessProxyCollection, removing: " + proxy.toString());
            }
            callback.setReturnValue((Object)max_power);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getDirectSignalTo"}, cancellable=true)
    public void getStrongPower(BlockPos pos, CallbackInfoReturnable<Integer> callback) {
        MinecraftServer server = this.m_142572_();
        if (server == null) {
            return;
        }
        ServerLevel world = server.m_129880_(this.m_46472_());
        if (world == null) {
            return;
        }
        AccessProxyCollection data = AccessProxyCollection.getInstance((net.minecraft.world.level.Level)world);
        HashSet<BlockPos> proxies = data.getProxiesFromTarget(pos);
        if (!proxies.isEmpty()) {
            int max_power = (Integer)callback.getReturnValue();
            for (BlockPos proxy : proxies) {
                BlockEntity tile = this.m_7702_(proxy);
                if (tile instanceof TileAccessProxy) {
                    max_power = Math.max(max_power, ((TileAccessProxy)tile).getStrongPowerForTarget());
                    continue;
                }
                data.remove(proxy);
                IntegratedProxy.clog(Level.WARN, "Found a tile that's not AccessProxy in AccessProxyCollection, removing: " + proxy.toString());
            }
            callback.setReturnValue((Object)max_power);
        }
    }
}

