/*
 * Decompiled with CFR 0.152.
 */
package com.shblock.integratedproxy.inventory.container;

import com.shblock.integratedproxy.IPRegistryEntries;
import com.shblock.integratedproxy.helper.DimPosHelper;
import com.shblock.integratedproxy.tileentity.TileAccessProxy;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.container.InventoryContainer;
import org.cyclops.integrateddynamics.core.inventory.container.slot.SlotVariable;

public class ContainerAccessProxy
extends InventoryContainer {
    private final Optional<TileAccessProxy> tileSupplier;
    public final int lastPosModeValueId;
    public final int lastTilePosNBTId;
    public final int lastXOkId;
    public final int lastYOkId;
    public final int lastZOkId;
    public final int lastDisplayOkId;
    public final int lastXErrorId;
    public final int lastYErrorId;
    public final int lastZErrorId;
    public final int lastDisplayErrorId;

    public ContainerAccessProxy(int id, Inventory playerInventory) {
        this(id, playerInventory, (Container)new SimpleContainer(4), Optional.empty());
    }

    public ContainerAccessProxy(int id, Inventory playerInventory, Container inventory, Optional<TileAccessProxy> tileSupplier) {
        super(IPRegistryEntries.CONTAINER_ACCESS_PROXY, id, playerInventory, inventory);
        this.tileSupplier = tileSupplier;
        for (int i = 0; i < 4; ++i) {
            this.m_38897_((Slot)new SlotVariable(inventory, i, this.offsetX + 27 + i * 36, this.offsetY + 52));
        }
        this.addPlayerInventory(playerInventory, this.offsetX + 9, this.offsetY + 88);
        this.lastPosModeValueId = this.getNextValueId();
        this.lastTilePosNBTId = this.getNextValueId();
        this.lastXOkId = this.getNextValueId();
        this.lastYOkId = this.getNextValueId();
        this.lastZOkId = this.getNextValueId();
        this.lastDisplayOkId = this.getNextValueId();
        this.lastXErrorId = this.getNextValueId();
        this.lastYErrorId = this.getNextValueId();
        this.lastZErrorId = this.getNextValueId();
        this.lastDisplayErrorId = this.getNextValueId();
    }

    public void m_38946_() {
        super.m_38946_();
        this.tileSupplier.ifPresent(tile -> {
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastTilePosNBTId, (Tag)DimPosHelper.toNBT(DimPos.of((Level)tile.m_58904_(), (BlockPos)tile.m_58899_())));
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastXOkId, (int)(tile.variableIntegerOk(tile.evaluator_x) ? 1 : 0));
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastYOkId, (int)(tile.variableIntegerOk(tile.evaluator_y) ? 1 : 0));
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastZOkId, (int)(tile.variableIntegerOk(tile.evaluator_z) ? 1 : 0));
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastDisplayOkId, (int)(tile.variableOk(tile.evaluator_display) ? 1 : 0));
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastXErrorId, (List)tile.evaluator_x.getErrors());
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastYErrorId, (List)tile.evaluator_y.getErrors());
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastZErrorId, (List)tile.evaluator_z.getErrors());
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastDisplayErrorId, (List)tile.evaluator_display.getErrors());
        });
    }

    public DimPos getTilePos() {
        return DimPosHelper.fromNBT((CompoundTag)ValueNotifierHelpers.getValueNbt((IValueNotifier)this, (int)this.lastTilePosNBTId));
    }

    public boolean variableOk(int valueId) {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)valueId) == 1;
    }

    protected void initializeValues() {
        this.tileSupplier.ifPresent(tile -> {
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastPosModeValueId, (int)tile.pos_mode);
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastTilePosNBTId, (Tag)DimPosHelper.toNBT(DimPos.of((Level)tile.m_58904_(), (BlockPos)tile.m_58899_())));
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastXOkId, (int)(tile.variableIntegerOk(tile.evaluator_x) ? 1 : 0));
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastYOkId, (int)(tile.variableIntegerOk(tile.evaluator_y) ? 1 : 0));
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastZOkId, (int)(tile.variableIntegerOk(tile.evaluator_z) ? 1 : 0));
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastDisplayOkId, (int)(tile.variableOk(tile.evaluator_display) ? 1 : 0));
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastXErrorId, (List)tile.evaluator_x.getErrors());
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastYErrorId, (List)tile.evaluator_y.getErrors());
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastZErrorId, (List)tile.evaluator_z.getErrors());
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastDisplayErrorId, (List)tile.evaluator_display.getErrors());
        });
    }

    public int getLastPosModeValue() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.lastPosModeValueId);
    }

    public List<MutableComponent> getErrors(int id) {
        return ValueNotifierHelpers.getValueTextComponentList((IValueNotifier)this, (int)id);
    }

    public void onUpdate(int valueId, CompoundTag value) {
        super.onUpdate(valueId, value);
        this.tileSupplier.ifPresent(tile -> {
            if (!tile.m_58904_().f_46443_ && valueId == this.lastPosModeValueId) {
                tile.pos_mode = this.getLastPosModeValue();
            }
        });
    }

    protected int getSizeInventory() {
        return 4;
    }
}

