/*
 * Decompiled with CFR 0.152.
 */
package com.shblock.integratedproxy.client.render.world;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.shblock.integratedproxy.client.data.AccessProxyClientData;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.integrateddynamics.api.client.render.valuetype.IValueTypeWorldRenderer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.client.render.valuetype.ValueTypeWorldRenderers;

public class AccessProxyTargetRenderer {
    @SubscribeEvent
    public static void onRender(RenderLevelLastEvent event) {
        DimPos target;
        DimPos proxy;
        RenderSystem.m_69472_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        float partialTicks = event.getPartialTick();
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer builder = buffer.m_6299_((RenderType)RenderType.f_110371_);
        PoseStack matrixStack = event.getPoseStack();
        matrixStack.m_85836_();
        matrixStack.m_85837_(-projectedView.f_82479_, -projectedView.f_82480_, -projectedView.f_82481_);
        for (Map.Entry<DimPos, DimPos> entry : AccessProxyClientData.getInstance().getTargetMap().entrySet()) {
            proxy = entry.getKey();
            target = entry.getValue();
            if (!target.getLevelKey().equals((Object)Minecraft.m_91087_().f_91073_.m_46472_()) || AccessProxyClientData.getInstance().getDisable(proxy)) continue;
            AABB bb = new AABB(new BlockPos(target.getBlockPos().m_123341_(), target.getBlockPos().m_123342_(), target.getBlockPos().m_123343_())).m_82363_(0.01, 0.01, 0.01).m_82363_(-0.01, -0.01, -0.01);
            LevelRenderer.m_109646_((PoseStack)event.getPoseStack(), (VertexConsumer)builder, (AABB)bb, (float)0.17f, (float)0.8f, (float)0.69f, (float)0.8f);
        }
        matrixStack.m_85849_();
        RenderSystem.m_69493_();
        buffer.m_109912_((RenderType)RenderType.f_110371_);
        matrixStack.m_85836_();
        for (Map.Entry<DimPos, DimPos> entry : AccessProxyClientData.getInstance().getTargetMap().entrySet()) {
            proxy = entry.getKey();
            target = entry.getValue();
            IValue value = AccessProxyClientData.getInstance().getVariable(proxy);
            int[] rotation = AccessProxyClientData.getInstance().getRotation(proxy);
            if (rotation == null || rotation.length == 0) {
                rotation = new int[]{0, 0, 0, 0, 0, 0};
            }
            if (value == null) continue;
            for (Direction facing : Direction.values()) {
                matrixStack.m_85836_();
                float scale = 0.08f;
                matrixStack.m_85837_(-projectedView.f_82479_ + (double)target.getBlockPos().m_123341_(), -projectedView.f_82480_ + (double)target.getBlockPos().m_123342_(), -projectedView.f_82481_ + (double)target.getBlockPos().m_123343_());
                AccessProxyTargetRenderer.translateToFacing(matrixStack, facing);
                matrixStack.m_85841_(scale, scale, scale);
                AccessProxyTargetRenderer.rotateSide(matrixStack, facing, rotation);
                matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
                AccessProxyTargetRenderer.rotateToFacing(matrixStack, facing);
                IValueTypeWorldRenderer renderer = ValueTypeWorldRenderers.REGISTRY.getRenderer(value.getType());
                if (renderer == null) {
                    renderer = ValueTypeWorldRenderers.DEFAULT;
                }
                Minecraft mc = Minecraft.m_91087_();
                renderer.renderValue(new BlockEntityRendererProvider.Context(mc.m_167982_(), mc.m_91289_(), mc.m_167973_(), mc.f_91062_), null, facing, null, value, partialTicks, matrixStack, (MultiBufferSource)buffer, LightTexture.m_109885_((int)15, (int)15), OverlayTexture.f_118083_, 1.0f);
                matrixStack.m_85849_();
            }
        }
        matrixStack.m_85849_();
        buffer.m_109911_();
    }

    private static void translateToFacing(PoseStack matrixStack, Direction facing) {
        switch (facing) {
            case DOWN: {
                matrixStack.m_85837_(1.0, (double)-0.015f, 0.0);
                break;
            }
            case UP: {
                matrixStack.m_85837_(1.0, (double)1.015f, 1.0);
                break;
            }
            case NORTH: {
                matrixStack.m_85837_(0.0, 1.0, (double)1.015f);
                break;
            }
            case SOUTH: {
                matrixStack.m_85837_(1.0, 1.0, (double)-0.015f);
                break;
            }
            case EAST: {
                matrixStack.m_85837_((double)1.015f, 1.0, 1.0);
                break;
            }
            case WEST: {
                matrixStack.m_85837_((double)-0.015f, 1.0, 0.0);
            }
        }
    }

    private static void rotateToFacing(PoseStack matrixStack, Direction facing) {
        int rotationY = 0;
        int rotationX = 0;
        if (facing == Direction.SOUTH) {
            rotationY = 0;
        } else if (facing == Direction.NORTH) {
            rotationY = 180;
        } else if (facing == Direction.EAST) {
            rotationY = 90;
        } else if (facing == Direction.WEST) {
            rotationY = -90;
        } else if (facing == Direction.UP) {
            rotationX = -90;
        } else if (facing == Direction.DOWN) {
            rotationX = 90;
        }
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_((float)rotationY));
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_((float)rotationX));
    }

    private static void rotateSide(PoseStack matrixStack, Direction side, int[] rotation) {
        switch (side) {
            case UP: {
                matrixStack.m_85837_(-6.25, 0.0, -6.25);
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_((float)(rotation[1] * 90)));
                matrixStack.m_85837_(6.25, 0.0, 6.25);
                break;
            }
            case DOWN: {
                matrixStack.m_85837_(-6.25, 0.0, 6.25);
                matrixStack.m_85845_(Vector3f.f_122225_.m_122240_((float)(rotation[0] * 90)));
                matrixStack.m_85837_(6.25, 0.0, -6.25);
                break;
            }
            case NORTH: {
                matrixStack.m_85837_(6.25, -6.25, 0.0);
                matrixStack.m_85845_(Vector3f.f_122227_.m_122240_((float)(rotation[3] * 90)));
                matrixStack.m_85837_(-6.25, 6.25, 0.0);
                break;
            }
            case SOUTH: {
                matrixStack.m_85837_(-6.25, -6.25, 0.0);
                matrixStack.m_85845_(Vector3f.f_122227_.m_122240_((float)(rotation[2] * 90)));
                matrixStack.m_85837_(6.25, 6.25, 0.0);
                break;
            }
            case WEST: {
                matrixStack.m_85837_(0.0, -6.25, 6.25);
                matrixStack.m_85845_(Vector3f.f_122223_.m_122240_((float)(rotation[4] * 90)));
                matrixStack.m_85837_(0.0, 6.25, -6.25);
                break;
            }
            case EAST: {
                matrixStack.m_85837_(0.0, -6.25, -6.25);
                matrixStack.m_85845_(Vector3f.f_122223_.m_122240_((float)(rotation[5] * 90)));
                matrixStack.m_85837_(0.0, 6.25, 6.25);
            }
        }
    }
}

