/*
 * Decompiled with CFR 0.152.
 */
package com.shblock.integratedproxy.block;

import com.shblock.integratedproxy.IPRegistryEntries;
import com.shblock.integratedproxy.storage.AccessProxyCollection;
import com.shblock.integratedproxy.tileentity.TileAccessProxy;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.integrateddynamics.api.block.IDynamicRedstone;
import org.cyclops.integrateddynamics.capability.dynamicredstone.DynamicRedstoneConfig;
import org.cyclops.integrateddynamics.core.block.BlockWithEntityGuiCabled;
import org.cyclops.integrateddynamics.core.helper.WrenchHelpers;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="integrated_proxy")
public class BlockAccessProxy
extends BlockWithEntityGuiCabled {
    public BlockAccessProxy(BlockBehaviour.Properties properties) {
        super(properties, TileAccessProxy::new);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return BlockAccessProxy.m_152132_(blockEntityType, IPRegistryEntries.TILE_ACCESS_PROXY, TileAccessProxy::updateTileEntity);
    }

    public void m_6807_(BlockState blockState, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(blockState, world, pos, oldState, isMoving);
        if (!world.f_46443_) {
            AccessProxyCollection.getInstance(world).set(pos, pos);
            TileAccessProxy te = (TileAccessProxy)world.m_7702_(pos);
            te.target = DimPos.of((Level)world, (BlockPos)pos);
            for (Direction facing : Direction.values()) {
                if (te.target == null || !world.m_46749_(te.target.getBlockPos()) || te.m_58901_()) continue;
                IDynamicRedstone cap = (IDynamicRedstone)BlockEntityHelpers.getCapability((DimPos)DimPos.of((Level)world, (BlockPos)pos.m_141952_(facing.m_122436_())), (Direction)facing.m_122424_(), (Capability)DynamicRedstoneConfig.CAPABILITY).orElse(null);
                te.setSideRedstonePower(facing, cap);
            }
        }
    }

    private void onDestroy(LevelReader world, BlockPos pos) {
        if (!world.m_5776_()) {
            TileAccessProxy te = (TileAccessProxy)world.m_7702_(pos);
            if (te == null) {
                return;
            }
            if (te.m_58901_() || te.target == null) {
                return;
            }
            te.sendRemoveRenderPacket();
            te.unRegisterEventHandle();
            AccessProxyCollection.getInstance((Level)world).remove(pos);
            te.updateTargetBlock();
            te.target = null;
            TileAccessProxy.updateAfterBlockDestroy((Level)world, pos);
        }
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos blockPos, Explosion explosion) {
        this.onDestroy((LevelReader)world, blockPos);
        super.onBlockExploded(state, world, blockPos, explosion);
    }

    public void m_6810_(BlockState oldState, Level world, BlockPos blockPos, BlockState newState, boolean isMoving) {
        this.onDestroy((LevelReader)world, blockPos);
        super.m_6810_(oldState, world, blockPos, newState, isMoving);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        this.onDestroy((LevelReader)world, pos);
        return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public InteractionResult m_6227_(BlockState blockState, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        if (!world.f_46443_) {
            if (player.m_6047_()) {
                if (player.m_21120_(hand).m_41619_()) {
                    ((TileAccessProxy)world.m_7702_(pos)).changeDisableRender();
                    return InteractionResult.SUCCESS;
                }
                return super.m_6227_(blockState, world, pos, player, hand, rayTraceResult);
            }
            if (WrenchHelpers.isWrench((Player)player, (ItemStack)player.m_21120_(hand), (Level)world, (BlockPos)pos, (Direction)rayTraceResult.m_82434_())) {
                ((TileAccessProxy)world.m_7702_(pos)).rotateDisplayValue(rayTraceResult.m_82434_());
                return InteractionResult.SUCCESS;
            }
            return super.m_6227_(blockState, world, pos, player, hand, rayTraceResult);
        }
        if (WrenchHelpers.isWrench((Player)player, (ItemStack)player.m_21120_(hand), (Level)world, (BlockPos)pos, (Direction)rayTraceResult.m_82434_())) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_6047_()) {
            if (player.m_21120_(hand).m_41619_()) {
                return InteractionResult.SUCCESS;
            }
        } else {
            return super.m_6227_(blockState, world, pos, player, hand, rayTraceResult);
        }
        return InteractionResult.FAIL;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean isMoving) {
        super.onNeighborChange(state, (LevelReader)world, pos, fromPos);
        if (neighborBlock instanceof BlockAccessProxy) {
            return;
        }
        if (!world.m_5776_()) {
            IDynamicRedstone cap;
            BlockPos facing_vec = fromPos.m_141950_(new Vec3i(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
            Direction facing = Direction.m_122378_((int)facing_vec.m_123341_(), (int)facing_vec.m_123342_(), (int)facing_vec.m_123343_());
            TileAccessProxy te = (TileAccessProxy)world.m_7702_(pos);
            if (te != null && te.target != null && world.m_46749_(te.target.getBlockPos()) && !te.m_58901_() && te.setSideRedstonePower(facing, cap = (IDynamicRedstone)BlockEntityHelpers.getCapability((DimPos)DimPos.of((Level)world, (BlockPos)fromPos), (Direction)facing.m_122424_(), (Capability)DynamicRedstoneConfig.CAPABILITY).orElse(null))) {
                te.updateTargetBlock();
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        if (!ModList.get().isLoaded("integratedtunnels")) {
            return;
        }
        if (event.getWorld().m_8055_(event.getPos()).m_60734_() instanceof BlockAccessProxy && event.getPlayer() instanceof FakePlayer) {
            event.setCanceled(true);
        }
    }

    @Nullable
    public MenuProvider m_7246_(BlockState p_49234_, Level p_49235_, BlockPos p_49236_) {
        return super.m_7246_(p_49234_, p_49235_, p_49236_);
    }
}

