/*
 * Decompiled with CFR 0.152.
 */
package brightspark.pollutantpump.block;

import brightspark.pollutantpump.PPConfig;
import brightspark.pollutantpump.PPContent;
import brightspark.pollutantpump.block.PipeBlock;
import brightspark.pollutantpump.block.PumpBlock;
import com.endertech.minecraft.forge.blocks.IPollutant;
import com.endertech.minecraft.mods.adpother.blocks.FilterFrame;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0002J,\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0011\"\u0004\b\u0000\u0010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J$\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0006\u0010!\u001a\u00020\u0018J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006%"}, d2={"Lbrightspark/pollutantpump/block/PumpTile;", "Lnet/minecraft/tileentity/TileEntity;", "Lnet/minecraft/tileentity/ITickableTileEntity;", "()V", "checkForPipes", "", "energy", "Lnet/minecraftforge/energy/EnergyStorage;", "lastWork", "", "topPipe", "Lnet/minecraft/util/math/BlockPos;", "wasPoweredLastTick", "Ljava/lang/Boolean;", "getAllPositionsInRange", "", "getCapability", "Lnet/minecraftforge/common/util/LazyOptional;", "T", "cap", "Lnet/minecraftforge/common/capabilities/Capability;", "side", "Lnet/minecraft/util/Direction;", "onLoad", "", "tick", "tryPumpPollutant", "pollutantState", "Lnet/minecraft/block/BlockState;", "pollutantBlock", "Lcom/endertech/minecraft/mods/adpother/blocks/Pollutant;", "pollutantAmount", "", "updatePipe", "updateState", "isPowered", "Companion", "pollutantpump"})
public final class PumpTile
extends TileEntity
implements ITickableTileEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EnergyStorage energy = new EnergyStorage(PPConfig.INSTANCE.getPumpMaxEnergyStorage(), Integer.MAX_VALUE);
    private boolean checkForPipes = true;
    @Nullable
    private BlockPos topPipe;
    @Nullable
    private Boolean wasPoweredLastTick;
    private long lastWork = -1L;
    @NotNull
    private static final Set<Direction> HORIZONTALS;

    public PumpTile() {
        super(PPContent.INSTANCE.getPUMP_TILE());
    }

    public void func_73660_a() {
        boolean isPowered;
        World world = this.field_145850_b;
        if (!(world == null ? false : !world.func_201670_d())) {
            return;
        }
        if (this.checkForPipes) {
            World world2 = this.field_145850_b;
            Intrinsics.checkNotNull((Object)world2);
            World world3 = world2;
            Intrinsics.checkNotNullExpressionValue((Object)world3, (String)"level!!");
            IWorld iWorld = (IWorld)world3;
            world3 = this.func_174877_v();
            Intrinsics.checkNotNullExpressionValue((Object)world3, (String)"blockPos");
            this.topPipe = PipeBlock.Companion.findTopOfPipes(iWorld, (BlockPos)world3);
            this.checkForPipes = false;
        }
        if (this.topPipe == null) {
            this.wasPoweredLastTick = null;
            this.updateState(false);
            return;
        }
        boolean bl = isPowered = this.energy.getEnergyStored() >= PPConfig.INSTANCE.getPumpEnergyUse();
        if (this.wasPoweredLastTick == null || !Intrinsics.areEqual((Object)isPowered, (Object)this.wasPoweredLastTick)) {
            this.wasPoweredLastTick = isPowered;
            this.updateState(isPowered);
        }
        World world4 = this.field_145850_b;
        Intrinsics.checkNotNull((Object)world4);
        if (world4.func_82737_E() - this.lastWork >= (long)PPConfig.INSTANCE.getPumpWorkRate() && isPowered) {
            World world5 = this.field_145850_b;
            Intrinsics.checkNotNull((Object)world5);
            this.lastWork = world5.func_82737_E();
            for (BlockPos it : this.getAllPositionsInRange()) {
                World world6 = this.field_145850_b;
                Intrinsics.checkNotNull((Object)world6);
                BlockState state = world6.func_180495_p(it);
                Block block = state.func_177230_c();
                if (!(block instanceof Pollutant) || ((IPollutant)block).getPollutantType() != IPollutant.Type.AIR) continue;
                int pollutantAmount = ((Pollutant)block).getCarriedPollutionAmount(state);
                Intrinsics.checkNotNullExpressionValue((Object)state, (String)"state");
                if (!this.tryPumpPollutant(state, (Pollutant)block, pollutantAmount)) continue;
                World world7 = this.field_145850_b;
                Intrinsics.checkNotNull((Object)world7);
                world7.func_180501_a(it, Blocks.field_150350_a.func_176223_P(), 2);
                break;
            }
        }
        this.energy.extractEnergy(PPConfig.INSTANCE.getPumpEnergyUse(), false);
    }

    private final void updateState(boolean isPowered) {
        World world = this.field_145850_b;
        Intrinsics.checkNotNull((Object)world);
        BlockPos blockPos = this.func_174877_v();
        World world2 = this.field_145850_b;
        Intrinsics.checkNotNull((Object)world2);
        world.func_180501_a(blockPos, (BlockState)world2.func_180495_p(this.func_174877_v()).func_206870_a((Property)PumpBlock.Companion.getPOWERED(), (Comparable)Boolean.valueOf(isPowered)), 2);
    }

    public final void updatePipe() {
        this.checkForPipes = true;
        this.topPipe = null;
    }

    private final List<BlockPos> getAllPositionsInRange() {
        List list;
        BlockPos blockPos = this.topPipe;
        if (blockPos == null) {
            list = null;
        } else {
            List list2;
            BlockPos top = blockPos;
            boolean bl = false;
            List $this$getAllPositionsInRange_u24lambda_u2d4_u24lambda_u2d3 = list2 = CollectionsKt.createListBuilder();
            boolean bl2 = false;
            Iterable $this$forEach$iv = (Iterable)new IntRange(top.func_177958_n() - PPConfig.INSTANCE.getPumpRangeWidth(), top.func_177958_n() + PPConfig.INSTANCE.getPumpRangeWidth());
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int x = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl3 = false;
                Iterable $this$forEach$iv2 = (Iterable)new IntRange(top.func_177956_o() - PPConfig.INSTANCE.getPumpRangeHeight(), top.func_177956_o() + PPConfig.INSTANCE.getPumpRangeHeight());
                boolean $i$f$forEach2 = false;
                Iterator iterator2 = $this$forEach$iv2.iterator();
                while (iterator2.hasNext()) {
                    int element$iv2;
                    int y = element$iv2 = ((IntIterator)iterator2).nextInt();
                    boolean bl4 = false;
                    Iterable $this$forEach$iv3 = (Iterable)new IntRange(top.func_177952_p() - PPConfig.INSTANCE.getPumpRangeWidth(), top.func_177952_p() + PPConfig.INSTANCE.getPumpRangeWidth());
                    boolean $i$f$forEach3 = false;
                    Iterator iterator3 = $this$forEach$iv3.iterator();
                    while (iterator3.hasNext()) {
                        int element$iv3;
                        int z = element$iv3 = ((IntIterator)iterator3).nextInt();
                        boolean bl5 = false;
                        $this$getAllPositionsInRange_u24lambda_u2d4_u24lambda_u2d3.add(new BlockPos(x, y, z));
                    }
                }
            }
            Collections.shuffle($this$getAllPositionsInRange_u24lambda_u2d4_u24lambda_u2d3);
            list = CollectionsKt.build((List)list2);
        }
        List list3 = list;
        return list3 == null ? CollectionsKt.emptyList() : list3;
    }

    private final boolean tryPumpPollutant(BlockState pollutantState, Pollutant<?> pollutantBlock, int pollutantAmount) {
        BlockPos sidePos;
        Direction side;
        List horizontals = CollectionsKt.shuffled((Iterable)HORIZONTALS);
        Iterable $this$forEach$iv = horizontals;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            side = (Direction)element$iv;
            boolean bl = false;
            sidePos = this.func_174877_v().func_177972_a(side);
            World world = this.field_145850_b;
            Intrinsics.checkNotNull((Object)world);
            BlockState sideState = world.func_180495_p(sidePos);
            Block sideBlock = sideState.func_177230_c();
            if (!(sideBlock instanceof FilterFrame)) continue;
            FilterFrame filter = (FilterFrame)sideBlock;
            Boolean movedToFilter = filter.getTile((IBlockReader)this.field_145850_b, this.func_174877_v()).map(arg_0 -> PumpTile.tryPumpPollutant$lambda-6$lambda-5(filter, pollutantBlock, pollutantAmount, arg_0)).orElse(false);
            Intrinsics.checkNotNullExpressionValue((Object)movedToFilter, (String)"movedToFilter");
            if (!movedToFilter.booleanValue()) continue;
            return true;
        }
        $this$forEach$iv = horizontals;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            side = (Direction)element$iv;
            boolean bl = false;
            sidePos = this.func_174877_v().func_177972_a(side);
            World world = this.field_145850_b;
            Intrinsics.checkNotNull((Object)world);
            if (!world.func_175623_d(sidePos)) continue;
            World world2 = this.field_145850_b;
            Intrinsics.checkNotNull((Object)world2);
            world2.func_180501_a(sidePos, pollutantState, 2);
            return true;
        }
        return false;
    }

    public void onLoad() {
        World world = this.field_145850_b;
        Intrinsics.checkNotNull((Object)world);
        this.lastWork = world.func_82737_E();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        LazyOptional lazyOptional;
        Intrinsics.checkNotNullParameter(cap, (String)"cap");
        if (Intrinsics.areEqual(cap, (Object)CapabilityEnergy.ENERGY)) {
            LazyOptional lazyOptional2 = LazyOptional.of(() -> PumpTile.getCapability$lambda-8(this)).cast();
            Intrinsics.checkNotNullExpressionValue((Object)lazyOptional2, (String)"of { energy }.cast()");
            lazyOptional = lazyOptional2;
        } else {
            LazyOptional lazyOptional3 = super.getCapability(cap, side);
            Intrinsics.checkNotNullExpressionValue((Object)lazyOptional3, (String)"super.getCapability(cap, side)");
            lazyOptional = lazyOptional3;
        }
        return lazyOptional;
    }

    private static final Boolean tryPumpPollutant$lambda-6$lambda-5(FilterFrame $filter, Pollutant $pollutantBlock, int $pollutantAmount, FilterFrame.BlockTile it) {
        Intrinsics.checkNotNullParameter((Object)$filter, (String)"$filter");
        Intrinsics.checkNotNullParameter((Object)$pollutantBlock, (String)"$pollutantBlock");
        int freeSpace = $filter.getContent(it).getFreeSpaceFor($pollutantBlock);
        if (freeSpace > $pollutantAmount) {
            $filter.fill(it, $pollutantBlock, $pollutantAmount);
            return true;
        }
        return false;
    }

    private static final EnergyStorage getCapability$lambda-8(PumpTile this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.energy;
    }

    static {
        Object[] objectArray = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
        HORIZONTALS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lbrightspark/pollutantpump/block/PumpTile$Companion;", "", "()V", "HORIZONTALS", "", "Lnet/minecraft/util/Direction;", "pollutantpump"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

