/*
 * Decompiled with CFR 0.152.
 */
package brightspark.pollutantpump.block;

import brightspark.pollutantpump.PPContent;
import brightspark.pollutantpump.block.PumpBlock;
import brightspark.pollutantpump.block.PumpTile;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 42\u00020\u0001:\u000245B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\t0\bH\u0014J \u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\tH\u0002J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u001aH\u0016J0\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J:\u0010 \u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\t2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$H\u0016J:\u0010%\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010&\u001a\u00020\u001f2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J8\u0010)\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u0010H\u0016J8\u0010.\u001a\u00020/2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016\u00a8\u00066"}, d2={"Lbrightspark/pollutantpump/block/PipeBlock;", "Lnet/minecraft/block/Block;", "props", "Lnet/minecraft/block/AbstractBlock$Properties;", "(Lnet/minecraft/block/AbstractBlock$Properties;)V", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/state/StateContainer$Builder;", "Lnet/minecraft/block/BlockState;", "dropTower", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "world", "Lnet/minecraft/world/server/ServerWorld;", "pos", "Lnet/minecraft/util/math/BlockPos;", "getActualState", "Lnet/minecraft/world/IWorld;", "state", "getShape", "Lnet/minecraft/util/math/shapes/VoxelShape;", "Lnet/minecraft/world/IBlockReader;", "context", "Lnet/minecraft/util/math/shapes/ISelectionContext;", "getStateForPlacement", "Lnet/minecraft/item/BlockItemUseContext;", "onPlace", "Lnet/minecraft/world/World;", "oldState", "isMoving", "", "playerDestroy", "te", "Lnet/minecraft/tileentity/TileEntity;", "stack", "Lnet/minecraft/item/ItemStack;", "removedByPlayer", "willHarvest", "fluid", "Lnet/minecraft/fluid/FluidState;", "updateShape", "facing", "Lnet/minecraft/util/Direction;", "facingState", "facingPos", "use", "Lnet/minecraft/util/ActionResultType;", "hand", "Lnet/minecraft/util/Hand;", "rayTraceResult", "Lnet/minecraft/util/math/BlockRayTraceResult;", "Companion", "PipeSize", "pollutantpump"})
public final class PipeBlock
extends Block {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final EnumProperty<PipeSize> PIPE_SIZE = EnumProperty.func_177709_a((String)"size", PipeSize.class);
    private static final VoxelShape BOX_FULL = VoxelShapes.func_197873_a((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)1.0, (double)0.75);
    private static final VoxelShape BOX_HALF = VoxelShapes.func_197873_a((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.5, (double)0.75);

    public PipeBlock(@NotNull AbstractBlock.Properties props) {
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        super(props);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)PIPE_SIZE, (Comparable)((Object)PipeSize.FULL)));
    }

    @NotNull
    public VoxelShape func_220053_a(@NotNull BlockState state, @NotNull IBlockReader world, @NotNull BlockPos pos, @NotNull ISelectionContext context) {
        VoxelShape voxelShape;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (state.func_177229_b((Property)PIPE_SIZE) == PipeSize.FULL) {
            VoxelShape voxelShape2 = BOX_FULL;
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"BOX_FULL");
            voxelShape = voxelShape2;
        } else {
            VoxelShape voxelShape3 = BOX_HALF;
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape3, (String)"BOX_HALF");
            voxelShape = voxelShape3;
        }
        return voxelShape;
    }

    @NotNull
    public BlockState func_196271_a(@NotNull BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull IWorld world, @NotNull BlockPos pos, @NotNull BlockPos facingPos) {
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        Intrinsics.checkNotNullParameter((Object)facingState, (String)"facingState");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)facingPos, (String)"facingPos");
        if (facing == Direction.UP || facing == Direction.DOWN) {
            blockState = this.getActualState(world, pos, state);
        } else {
            BlockState blockState2 = super.func_196271_a(state, facing, facingState, world, pos, facingPos);
            Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"super.updateShape(state,\u2026e, world, pos, facingPos)");
            blockState = blockState2;
        }
        return blockState;
    }

    @NotNull
    public BlockState func_196258_a(@NotNull BlockItemUseContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        World world = context.func_195991_k();
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"context.level");
        IWorld iWorld = (IWorld)world;
        world = context.func_195995_a();
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"context.clickedPos");
        World world2 = world;
        world = this.func_176223_P();
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"defaultBlockState()");
        return this.getActualState(iWorld, (BlockPos)world2, (BlockState)world);
    }

    private final BlockState getActualState(IWorld world, BlockPos pos, BlockState state) {
        Block down = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        Block up = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        boolean isHalf = (down instanceof PipeBlock || down instanceof PumpBlock) && !(up instanceof PipeBlock);
        Object object = state.func_206870_a((Property)PIPE_SIZE, (Comparable)((Object)(isHalf ? PipeSize.HALF : PipeSize.FULL)));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"state.setValue(PIPE_SIZE\u2026.HALF else PipeSize.FULL)");
        return (BlockState)object;
    }

    protected void func_206840_a(@NotNull StateContainer.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{(Property)PIPE_SIZE};
        builder.func_206894_a(propertyArray);
    }

    public void func_220082_b(@NotNull BlockState state, @NotNull World world, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        PipeBlock.Companion.notifyPump((IWorld)world, pos);
    }

    @NotNull
    public ActionResultType func_225533_a_(@NotNull BlockState state, @NotNull World world, @NotNull BlockPos pos, @NotNull PlayerEntity player, @NotNull Hand hand, @NotNull BlockRayTraceResult rayTraceResult) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)rayTraceResult, (String)"rayTraceResult");
        ItemStack heldStack = player.func_184586_b(hand);
        if (Intrinsics.areEqual((Object)heldStack.func_77973_b(), (Object)PPContent.INSTANCE.getPIPE_ITEM())) {
            BlockPos topPipe = Companion.findTopOfPipes((IWorld)world, pos);
            if (Intrinsics.areEqual((Object)topPipe, (Object)BlockPos.field_177992_a)) {
                topPipe = pos;
            }
            BlockPos aboveTopPipe = topPipe.func_177984_a();
            IWorld iWorld = (IWorld)world;
            Intrinsics.checkNotNullExpressionValue((Object)aboveTopPipe, (String)"aboveTopPipe");
            BlockState blockState = this.func_176223_P();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"defaultBlockState()");
            BlockState placeState = this.getActualState(iWorld, aboveTopPipe, blockState);
            if (world.func_175623_d(aboveTopPipe) && world.func_180501_a(aboveTopPipe, placeState, 3)) {
                SoundType soundType = this.getSoundType(state, (IWorldReader)world, pos, (Entity)player);
                world.func_184133_a(player, pos, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.field_185861_n * 0.8f);
                if (!player.func_184812_l_()) {
                    heldStack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public void func_180657_a(@NotNull World world, @NotNull PlayerEntity player, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable TileEntity te, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        player.func_71029_a(Stats.field_188065_ae.func_199076_b((Object)this));
        player.func_71020_j(0.005f);
        if (world.func_201670_d()) {
            return;
        }
        this.dropTower(player, (ServerWorld)world, pos);
    }

    public boolean removedByPlayer(@NotNull BlockState state, @NotNull World world, @NotNull BlockPos pos, @NotNull PlayerEntity player, boolean willHarvest, @Nullable FluidState fluid) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (player.func_184812_l_()) {
            BlockPos.Mutable towerPos = pos.func_239590_i_();
            while (world.func_180495_p((BlockPos)towerPos.func_189536_c(Direction.UP)).func_177230_c() instanceof PipeBlock) {
                world.func_175655_b((BlockPos)towerPos, false);
            }
        }
        boolean it = bl = super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
        boolean bl2 = false;
        PipeBlock.Companion.notifyPump((IWorld)world, pos);
        return bl;
    }

    private final void dropTower(PlayerEntity player, ServerWorld world, BlockPos pos) {
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Set drops = new LinkedHashSet();
        BlockPos.Mutable towerPos = pos.func_239590_i_().func_189536_c(Direction.UP);
        BlockState state = world.func_180495_p((BlockPos)towerPos);
        do {
            List list = Block.func_220070_a((BlockState)state, (ServerWorld)world, (BlockPos)((BlockPos)towerPos), null);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDrops(state, world, towerPos, null)");
            $this$forEach$iv = list;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ItemStack $this$dropTower_u24lambda_u2d3_u24lambda_u2d2;
                Object v0;
                ItemStack dropStack;
                block5: {
                    dropStack = (ItemStack)element$iv;
                    boolean bl = false;
                    for (Object t : (Iterable)drops) {
                        ItemStack it = (ItemStack)t;
                        boolean bl2 = false;
                        if (!ItemStack.func_77989_b((ItemStack)it, (ItemStack)dropStack)) continue;
                        v0 = t;
                        break block5;
                    }
                    v0 = null;
                }
                if ((ItemStack)v0 == null) continue;
                boolean bl = false;
                $this$dropTower_u24lambda_u2d3_u24lambda_u2d2.func_190917_f(dropStack.func_190916_E());
            }
            world.func_175655_b((BlockPos)towerPos, false);
        } while ((state = world.func_180495_p((BlockPos)towerPos.func_189536_c(Direction.UP))).func_177230_c() instanceof PipeBlock);
        if (!player.func_184812_l_()) {
            $this$forEach$iv = drops;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ItemStack it = (ItemStack)element$iv;
                boolean bl = false;
                Block.func_180635_a((World)((World)world), (BlockPos)pos, (ItemStack)it);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0016\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\t0\t \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lbrightspark/pollutantpump/block/PipeBlock$Companion;", "", "()V", "BOX_FULL", "Lnet/minecraft/util/math/shapes/VoxelShape;", "kotlin.jvm.PlatformType", "BOX_HALF", "PIPE_SIZE", "Lnet/minecraft/state/EnumProperty;", "Lbrightspark/pollutantpump/block/PipeBlock$PipeSize;", "findBottomOfPipes", "Lnet/minecraft/util/math/BlockPos;", "world", "Lnet/minecraft/world/IWorld;", "pos", "findTopOfPipes", "notifyPump", "", "pollutantpump"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BlockPos findTopOfPipes(@NotNull IWorld world, @NotNull BlockPos pos) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            BlockPos.Mutable checkPos = pos.func_239590_i_();
            BlockPos.Mutable topPos = BlockPos.field_177992_a.func_239590_i_();
            int n = pos.func_177956_o() + 1;
            int n2 = world.func_234938_ad_();
            while (n < n2) {
                int y = n++;
                checkPos.func_185336_p(y);
                if (!(world.func_180495_p((BlockPos)checkPos).func_177230_c() instanceof PipeBlock)) break;
                topPos.func_189533_g((Vector3i)checkPos);
            }
            BlockPos blockPos = topPos.func_185334_h();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"topPos.immutable()");
            return blockPos;
        }

        private final BlockPos findBottomOfPipes(IWorld world, BlockPos pos) {
            BlockPos.Mutable checkPos = pos.func_239590_i_().func_189536_c(Direction.DOWN);
            while (world.func_180495_p((BlockPos)checkPos).func_177230_c() instanceof PipeBlock) {
                checkPos.func_189536_c(Direction.DOWN);
            }
            BlockPos blockPos = checkPos.func_185334_h();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"checkPos.immutable()");
            return blockPos;
        }

        private final void notifyPump(IWorld world, BlockPos pos) {
            TileEntity te;
            BlockPos bottomPos = this.findBottomOfPipes(world, pos);
            Block block = world.func_180495_p(bottomPos).func_177230_c();
            if (block instanceof PumpBlock && (te = world.func_175625_s(bottomPos)) instanceof PumpTile) {
                ((PumpTile)te).updatePipe();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lbrightspark/pollutantpump/block/PipeBlock$PipeSize;", "", "Lnet/minecraft/util/IStringSerializable;", "serializedName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getSerializedName", "FULL", "HALF", "pollutantpump"})
    public static final class PipeSize
    extends Enum<PipeSize>
    implements IStringSerializable {
        @NotNull
        private final String serializedName;
        public static final /* enum */ PipeSize FULL = new PipeSize("full");
        public static final /* enum */ PipeSize HALF = new PipeSize("half");
        private static final /* synthetic */ PipeSize[] $VALUES;

        private PipeSize(String serializedName) {
            this.serializedName = serializedName;
        }

        @NotNull
        public String func_176610_l() {
            return this.serializedName;
        }

        public static PipeSize[] values() {
            return (PipeSize[])$VALUES.clone();
        }

        public static PipeSize valueOf(String value) {
            return Enum.valueOf(PipeSize.class, value);
        }

        static {
            $VALUES = pipeSizeArray = new PipeSize[]{PipeSize.FULL, PipeSize.HALF};
        }
    }
}

