/*
 * Decompiled with CFR 0.152.
 */
package brightspark.pollutantpump;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\b\u00a8\u0006\u0011"}, d2={"Lbrightspark/pollutantpump/PPServerConfig;", "", "builder", "Lnet/minecraftforge/common/ForgeConfigSpec$Builder;", "(Lnet/minecraftforge/common/ForgeConfigSpec$Builder;)V", "pumpEnergyUse", "Lnet/minecraftforge/common/ForgeConfigSpec$IntValue;", "getPumpEnergyUse", "()Lnet/minecraftforge/common/ForgeConfigSpec$IntValue;", "pumpMaxEnergyStorage", "getPumpMaxEnergyStorage", "pumpRangeHeight", "getPumpRangeHeight", "pumpRangeWidth", "getPumpRangeWidth", "pumpWorkRate", "getPumpWorkRate", "pollutantpump"})
public final class PPServerConfig {
    @NotNull
    private final ForgeConfigSpec.IntValue pumpMaxEnergyStorage;
    @NotNull
    private final ForgeConfigSpec.IntValue pumpEnergyUse;
    @NotNull
    private final ForgeConfigSpec.IntValue pumpWorkRate;
    @NotNull
    private final ForgeConfigSpec.IntValue pumpRangeHeight;
    @NotNull
    private final ForgeConfigSpec.IntValue pumpRangeWidth;

    public PPServerConfig(@NotNull ForgeConfigSpec.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        ForgeConfigSpec.IntValue intValue = builder.comment("The max amount of energy the pump will hold").defineInRange("pumpMaxEnergyStorage", 1000, 0, Integer.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)intValue, (String)"builder\n\t\t.comment(\"The \u2026, 1000, 0, Int.MAX_VALUE)");
        this.pumpMaxEnergyStorage = intValue;
        intValue = builder.comment("The amount of energy the pump will use per tick").defineInRange("pumpEnergyUse", 50, 0, Integer.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)intValue, (String)"builder\n\t\t.comment(\"The \u2026e\", 50, 0, Int.MAX_VALUE)");
        this.pumpEnergyUse = intValue;
        intValue = builder.comment("The time in ticks between each pollutant block the pump tries to suck up").defineInRange("pumpWorkRate", 60, 1, Integer.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)intValue, (String)"builder\n\t\t.comment(\"The \u2026e\", 60, 1, Int.MAX_VALUE)");
        this.pumpWorkRate = intValue;
        intValue = builder.comment("The height range (Y) from the top pipe that pollution will be sucked from").defineInRange("pumpRangeHeight", 1, 0, Integer.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)intValue, (String)"builder\n\t\t.comment(\"The \u2026ht\", 1, 0, Int.MAX_VALUE)");
        this.pumpRangeHeight = intValue;
        intValue = builder.comment("The width range (X/Z) from the top pipe that pollution will be sucked from").defineInRange("pumpRangeWidth", 5, 1, Integer.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)intValue, (String)"builder\n\t\t.comment(\"The \u2026th\", 5, 1, Int.MAX_VALUE)");
        this.pumpRangeWidth = intValue;
    }

    @NotNull
    public final ForgeConfigSpec.IntValue getPumpMaxEnergyStorage() {
        return this.pumpMaxEnergyStorage;
    }

    @NotNull
    public final ForgeConfigSpec.IntValue getPumpEnergyUse() {
        return this.pumpEnergyUse;
    }

    @NotNull
    public final ForgeConfigSpec.IntValue getPumpWorkRate() {
        return this.pumpWorkRate;
    }

    @NotNull
    public final ForgeConfigSpec.IntValue getPumpRangeHeight() {
        return this.pumpRangeHeight;
    }

    @NotNull
    public final ForgeConfigSpec.IntValue getPumpRangeWidth() {
        return this.pumpRangeWidth;
    }
}

