/*
 * Decompiled with CFR 0.152.
 */
package brightspark.pollutantpump.blocks;

import brightspark.pollutantpump.blocks.BlockBase;
import brightspark.pollutantpump.blocks.BlockPump;
import brightspark.pollutantpump.tiles.TilePump;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class BlockPipe
extends BlockBase {
    public static final PropertyEnum<PipeSize> PIPE_SIZE = PropertyEnum.func_177709_a((String)"size", PipeSize.class);
    private static final AxisAlignedBB BOX_FULL = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    private static final AxisAlignedBB BOX_HALF = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);

    public BlockPipe() {
        super("pipe");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(PIPE_SIZE, (Comparable)((Object)PipeSize.FULL)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.func_176221_a(state, source, pos).func_177229_b(PIPE_SIZE) == PipeSize.FULL ? BOX_FULL : BOX_HALF;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        Block down = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        Block up = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
        boolean isHalf = (down instanceof BlockPipe || down instanceof BlockPump) && !(up instanceof BlockPipe);
        return state.func_177226_a(PIPE_SIZE, (Comparable)((Object)(isHalf ? PipeSize.HALF : PipeSize.FULL)));
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PIPE_SIZE});
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.notifyPump(worldIn, pos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack held = player.func_184586_b(hand);
        if (held.func_77973_b() == Item.func_150898_a((Block)this)) {
            BlockPos topPipe = BlockPipe.findTop(world, pos);
            if (topPipe == null) {
                topPipe = pos;
            }
            if (world.func_175623_d(topPipe.func_177984_a()) && world.func_175656_a(topPipe.func_177984_a(), this.func_176223_P())) {
                SoundType soundType = this.getSoundType(state, world, pos, (Entity)player);
                world.func_184133_a(player, pos, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
                if (!player.func_184812_l_()) {
                    held.func_190918_g(1);
                }
                return true;
            }
        }
        return false;
    }

    public static BlockPos findTop(World world, BlockPos pos) {
        BlockPos checkPos;
        Block block;
        BlockPos top = null;
        for (int y = pos.func_177956_o() + 1; y < world.func_72800_K() && (block = world.func_180495_p(checkPos = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p())).func_177230_c()) instanceof BlockPipe; ++y) {
            top = new BlockPos((Vec3i)checkPos);
        }
        return top;
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.005f);
        Item item = Item.func_150898_a((Block)this);
        int count = 1;
        BlockPos.MutableBlockPos towerPos = new BlockPos.MutableBlockPos(pos);
        while (world.func_180495_p((BlockPos)towerPos.func_189536_c(EnumFacing.UP)).func_177230_c() instanceof BlockPipe) {
            world.func_175655_b((BlockPos)towerPos, false);
            ++count;
        }
        if (!player.func_184812_l_()) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            while (count > 0) {
                int dropCount = Math.min(count, 64);
                count -= dropCount;
                drops.add(new ItemStack(item, dropCount));
            }
            ForgeEventFactory.fireBlockHarvesting(drops, (World)world, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)false, (EntityPlayer)player);
            drops.forEach(drop -> BlockPipe.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drop));
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (player.func_184812_l_()) {
            BlockPos.MutableBlockPos towerPos = new BlockPos.MutableBlockPos(pos);
            while (world.func_180495_p((BlockPos)towerPos.func_189536_c(EnumFacing.UP)).func_177230_c() instanceof BlockPipe) {
                world.func_175655_b((BlockPos)towerPos, false);
            }
        }
        boolean result = super.removedByPlayer(state, world, pos, player, willHarvest);
        this.notifyPump(world, pos);
        return result;
    }

    private BlockPos findBottomOfPipes(World world, BlockPos pos) {
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos(pos).func_189536_c(EnumFacing.DOWN);
        while (world.func_180495_p((BlockPos)checkPos).func_177230_c() instanceof BlockPipe) {
            checkPos.func_189536_c(EnumFacing.DOWN);
        }
        return checkPos.func_185334_h();
    }

    private void notifyPump(World world, BlockPos pos) {
        TileEntity te;
        BlockPos bottomPos = this.findBottomOfPipes(world, pos);
        Block block = world.func_180495_p(bottomPos).func_177230_c();
        if (block instanceof BlockPump && (te = world.func_175625_s(bottomPos)) instanceof TilePump) {
            ((TilePump)te).updatePipe();
        }
    }

    public static enum PipeSize implements IStringSerializable
    {
        FULL("full"),
        HALF("half");

        private final String name;

        private PipeSize(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

