/*
 * Decompiled with CFR 0.152.
 */
package net.abyss.addon.thebeginning.world.structure;

import java.util.Random;
import net.abyss.addon.thebeginning.ThebeginningModElements;
import net.abyss.addon.thebeginning.block.BegGrassBlockBlock;
import net.minecraft.block.BlockState;
import net.minecraft.util.Mirror;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@ThebeginningModElements.ModElement.Tag
public class LifeShroomStructure
extends ThebeginningModElements.ModElement {
    private static final Feature<NoFeatureConfig> feature = new Feature<NoFeatureConfig>(NoFeatureConfig.field_236558_a_){

        public boolean generate(ISeedReader world, ChunkGenerator generator, Random random, BlockPos pos, NoFeatureConfig config) {
            int ci = pos.func_177958_n() >> 4 << 4;
            int ck = pos.func_177952_p() >> 4 << 4;
            RegistryKey dimensionType = world.func_201672_e().func_234923_W_();
            boolean dimensionCriteria = false;
            if (dimensionType == World.field_234918_g_) {
                dimensionCriteria = true;
            }
            if (dimensionType == RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("thebeginning:theabyssdimbeginning"))) {
                dimensionCriteria = true;
            }
            if (dimensionType == RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("thebeginning:the_abyss_beginning_ground_lands"))) {
                dimensionCriteria = true;
            }
            if (!dimensionCriteria) {
                return false;
            }
            if (random.nextInt(1000000) + 1 <= 800000) {
                int count = random.nextInt(1) + 1;
                for (int a = 0; a < count; ++a) {
                    int i = ci + random.nextInt(16);
                    int k = ck + random.nextInt(16);
                    int j = world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, i, k);
                    BlockState blockAt = world.func_180495_p(new BlockPos(i, --j, k));
                    boolean blockCriteria = false;
                    if (blockAt.func_177230_c() == BegGrassBlockBlock.block.func_176223_P().func_177230_c()) {
                        blockCriteria = true;
                    }
                    if (!blockCriteria) continue;
                    Rotation rotation = Rotation.NONE;
                    Mirror mirror = Mirror.NONE;
                    BlockPos spawnTo = new BlockPos(i + -1, j + -1, k + -1);
                    int x = spawnTo.func_177958_n();
                    int y = spawnTo.func_177956_o();
                    int z = spawnTo.func_177952_p();
                    Template template = world.func_201672_e().func_184163_y().func_200220_a(new ResourceLocation("thebeginning", "abysswart1"));
                    if (template == null) {
                        return false;
                    }
                    template.func_237144_a_((IServerWorld)world, spawnTo, new PlacementSettings().func_186220_a(rotation).func_189950_a(random).func_186214_a(mirror).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a).func_186218_a(null).func_186222_a(false), random);
                }
            }
            return true;
        }
    };

    public LifeShroomStructure(ThebeginningModElements instance) {
        super(instance, 22);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new FeatureRegisterHandler());
    }

    @SubscribeEvent
    public void addFeatureToBiomes(BiomeLoadingEvent event) {
        boolean biomeCriteria = false;
        if (new ResourceLocation("thebeginning:flora_forest").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("thebeginning:ruma_forest").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (!biomeCriteria) {
            return;
        }
        event.getGeneration().getFeatures(GenerationStage.Decoration.SURFACE_STRUCTURES).add(() -> feature.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
    }

    private static class FeatureRegisterHandler {
        private FeatureRegisterHandler() {
        }

        @SubscribeEvent
        public void registerFeature(RegistryEvent.Register<Feature<?>> event) {
            event.getRegistry().register(feature.setRegistryName("life_shroom"));
        }
    }
}

