/*
 * Decompiled with CFR 0.152.
 */
package com.github.elrol.industrialagriculture.silentsmechanisms;

import com.blakebr0.mysticalagriculture.api.crop.CropTextures;
import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.github.elrol.industrialagriculture.init.ColorInit;
import com.github.elrol.industrialagriculture.init.CropInit;
import com.github.elrol.industrialagriculture.init.CruxInit;
import com.github.elrol.industrialagriculture.silentsmechanisms.config.Config;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="iapsm")
public class IAP_SilentsMechanisms {
    public static final Logger LOGGER = LogManager.getLogger();
    public static Config config;
    private static final CropTextures ingotTextures;

    public IAP_SilentsMechanisms() {
        config = Config.load();
        this.colorInit();
        this.soulInit();
        this.cropInit();
    }

    private void colorInit() {
        ColorInit.addColor((String)"bismuth", (int)13746901);
        ColorInit.addColor((String)"redstone_alloy", (int)0xE60006);
        ColorInit.addColor((String)"compressed_iron", (int)0xA6A6A6);
        ColorInit.addColor((String)"refined_iron", (int)0xE5E8E8);
        ColorInit.addColor((String)"bismuth_brass", (int)15319476);
        ColorInit.addColor((String)"bismuth_steel", (int)14458855);
        ColorInit.addColor((String)"aluminum_steel", (int)10017242);
    }

    private void soulInit() {
    }

    private void cropInit() {
        CruxInit.addCruxBlocks(config.getCruxMap());
        this.initCrop("bismuth");
        this.initCrop("redstone_alloy");
        this.initCrop("compressed_iron");
        this.initCrop("refined_iron");
        this.initCrop("bismuth_brass");
        this.initCrop("bismuth_steel");
        this.initCrop("aluminum_steel");
    }

    private void initCrop(String name) {
        LOGGER.info("IAPSM: Init Crop " + name);
        CropInit.addTagResourceCrop((String)name, (CropTier)config.getCropTier(name), (String)("forge:ingots/" + name), (CropTextures)ingotTextures);
    }

    static {
        ingotTextures = new CropTextures(CropTextures.FLOWER_INGOT_BLANK, CropTextures.ESSENCE_INGOT_BLANK, CropTextures.SEED_BLANK);
    }
}

