/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.jei.endercrafter;

import com.blakebr0.cucumber.helper.ResourceHelper;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.extendedcrafting.compat.jei.tablecrafting.TableShapedWrapper;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class EnderCrafterCategory
implements IRecipeCategory<IRecipeWrapper> {
    public static final String UID = "extendedcrafting:ender_crafting";
    private static final ResourceLocation TEXTURE = ResourceHelper.getResource((String)"extendedcrafting", (String)"textures/jei/ender_crafting.png");
    private final IDrawable background;
    private final IDrawableAnimated arrow;

    public EnderCrafterCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 116, 54);
        IDrawableStatic arrowDrawable = helper.createDrawable(TEXTURE, 195, 0, 24, 17);
        this.arrow = helper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return Utils.localize((String)"jei.ec.ender_crafting");
    }

    public String getModName() {
        return "ExtendedCrafting: Nomifactory Edition";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
        this.arrow.draw(minecraft, 61, 19);
    }

    public void setRecipe(IRecipeLayout layout, IRecipeWrapper wrapper, IIngredients ingredients) {
        int GRID_N = 3;
        int CELL_PX = 18;
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0);
        IGuiItemStackGroup stackGroup = layout.getItemStacks();
        stackGroup.init(0, false, 94, 18);
        stackGroup.set(0, outputs);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                stackGroup.init(1 + x + y * 3, true, x * 18, y * 18);
            }
        }
        if (wrapper instanceof TableShapedWrapper) {
            TableShapedWrapper recipe = (TableShapedWrapper)wrapper;
            int inputIndex = 0;
            for (int row = 0; row < recipe.getHeight(); ++row) {
                for (int column = 0; column < recipe.getWidth(); ++column) {
                    stackGroup.set(1 + column + row * 3, (List)inputs.get(inputIndex++));
                }
            }
        } else {
            for (int index = 0; index < inputs.size(); ++index) {
                stackGroup.set(index + 1, (List)inputs.get(index));
            }
            layout.setShapeless();
        }
        layout.setRecipeTransferButton(122, 41);
    }
}

