/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.gregtech;

import com.blakebr0.extendedcrafting.compat.gregtech.IGTCapHolder;
import com.blakebr0.extendedcrafting.config.ModConfig;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.IEnergyStorage;

public interface IGTEnergyContainer
extends IEnergyContainer,
IGTCapHolder {
    public IEnergyStorage getEnergy();

    @Override
    @Nullable
    default public <T> T getGTCapability(@Nonnull Capability<T> capability) {
        if (capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
            return (T)GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER.cast((Object)this);
        }
        return null;
    }

    public static int euToRF(long eu) {
        return (int)Math.min((long)(Integer.MAX_VALUE / ModConfig.confEUtoRF), eu) * ModConfig.confEUtoRF;
    }

    public static long rfToEU(int rf) {
        return (long)rf / (long)ModConfig.confEUtoRF;
    }

    default public long acceptEnergyFromNetwork(EnumFacing side, long voltage, long amperage) {
        if (voltage <= 0L || amperage <= 0L || side != null && !this.inputsEnergy(side)) {
            return 0L;
        }
        long amperesAccepted = Math.min(this.getEnergyCanBeInserted() / voltage, Math.min(amperage, this.getInputAmperage()));
        if (amperesAccepted <= 0L) {
            return 0L;
        }
        this.addEnergy(voltage * amperesAccepted);
        return amperesAccepted;
    }

    default public boolean inputsEnergy(EnumFacing enumFacing) {
        return this.getEnergy().canReceive();
    }

    default public long changeEnergy(long difference) {
        return IGTEnergyContainer.rfToEU(difference >= 0L ? this.getEnergy().receiveEnergy(IGTEnergyContainer.euToRF(difference), false) : this.getEnergy().extractEnergy(IGTEnergyContainer.euToRF(-difference), false));
    }

    default public long getEnergyStored() {
        return IGTEnergyContainer.rfToEU(this.getEnergy().getEnergyStored());
    }

    default public long getEnergyCapacity() {
        return IGTEnergyContainer.rfToEU(this.getEnergy().getMaxEnergyStored());
    }

    default public long getInputAmperage() {
        return Long.MAX_VALUE;
    }

    default public long getInputVoltage() {
        return Long.MAX_VALUE;
    }
}

