/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tools.engineering;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.model.ITransformation;
import net.minecraftforge.common.model.TRSRTransformation;
import org.lwjgl.util.vector.Vector3f;
import pl.asie.charset.lib.render.CharsetFaceBakery;
import pl.asie.charset.lib.render.model.WrappedBakedModel;
import pl.asie.charset.lib.stagingapi.ISignalMeterData;
import pl.asie.charset.lib.stagingapi.ISignalMeterDataBands;
import pl.asie.charset.lib.stagingapi.ISignalMeterDataDots;
import pl.asie.charset.module.tools.engineering.CharsetToolsEngineering;
import pl.asie.charset.module.tools.engineering.ISignalMeterTracker;

public class ModelSignalMeter
extends WrappedBakedModel {
    public static TextureAtlasSprite WHITE;
    private final ISignalMeterData data;
    private static final ItemOverrideList OVERRIDE_LIST;

    public ModelSignalMeter(IBakedModel parent) {
        this(parent, null);
    }

    public ModelSignalMeter(IBakedModel parent, ISignalMeterData data) {
        super(parent);
        this.data = data;
        this.addDefaultItemTransforms();
        this.addFirstPersonTransformation(ModelSignalMeter.getTransformation((float)-1.0f, (float)3.2f, (float)1.13f, (float)0.0f, (float)-7.0f, (float)0.0f, (float)0.68f));
    }

    private int fixColor(int v) {
        return v & 0xFF00FF00 | (v & 0xFF) << 16 | v >> 16 & 0xFF;
    }

    public float getDotSize(ISignalMeterDataDots dots) {
        return Math.min(8.0f / (float)dots.getDotCount(), 1.0f);
    }

    public void renderDots(List<BakedQuad> quads, ISignalMeterDataDots dots) {
        float z = 8.502f;
        float dotSize = this.getDotSize(dots);
        float dotStart = 10.5f - dotSize / 2.0f;
        if (dots instanceof ISignalMeterDataBands) {
            dotStart += 2.5f;
        }
        float bx = 4.0f + (8.0f - (float)dots.getDotCount() * dotSize) / 2.0f;
        int i = 0;
        while (i < dots.getDotCount()) {
            int col = dots.getDotColor(i);
            if ((col & 0xFF000000) != 0) {
                quads.add(CharsetFaceBakery.INSTANCE.makeBakedQuad(new Vector3f(bx, dotStart, z), new Vector3f(bx + dotSize, dotStart + dotSize, z), this.fixColor(col | 0xFF000000), WHITE, EnumFacing.SOUTH, (ITransformation)TRSRTransformation.identity(), false));
            }
            ++i;
            bx += dotSize;
        }
    }

    public void renderBands(List<BakedQuad> quads, ISignalMeterDataBands bands) {
        float z = 8.502f;
        float bandStart = 8.0f;
        float bandHeight = 5.5f;
        float bandWidth = Math.min(8.0f / (float)bands.getBandCount(), 1.0f);
        if (bands instanceof ISignalMeterDataDots) {
            bandHeight -= this.getDotSize((ISignalMeterDataDots)bands) + 1.0f;
        }
        float bx = 4.0f + (8.0f - (float)bands.getBandCount() * bandWidth) / 2.0f;
        float yStart = bandStart;
        float yEnd = bandStart + bandHeight;
        int i = 0;
        while (i < bands.getBandCount()) {
            int bgCol;
            int col;
            float yMid = yEnd - (1.0f - bands.getBandHeight(i)) * bandHeight;
            if (yMid != yStart && ((col = bands.getBandColor(i)) & 0xFF000000) != 0) {
                quads.add(CharsetFaceBakery.INSTANCE.makeBakedQuad(new Vector3f(bx, yStart, z), new Vector3f(bx + bandWidth, yMid, z), this.fixColor(col | 0xFF000000), WHITE, EnumFacing.SOUTH, (ITransformation)TRSRTransformation.identity(), false));
            }
            if (((bgCol = bands.getBandBackgroundColor(i)) & 0xFF000000) != 0 && yMid != yEnd) {
                quads.add(CharsetFaceBakery.INSTANCE.makeBakedQuad(new Vector3f(bx, yMid, z), new Vector3f(bx + bandWidth, yEnd, z), this.fixColor(bgCol | 0xFF000000), WHITE, EnumFacing.SOUTH, (ITransformation)TRSRTransformation.identity(), false));
            }
            ++i;
            bx += bandWidth;
        }
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (side == null && this.data != null) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            quads.addAll(super.func_188616_a(state, side, rand));
            if (this.data instanceof ISignalMeterDataDots) {
                this.renderDots(quads, (ISignalMeterDataDots)this.data);
            }
            if (this.data instanceof ISignalMeterDataBands) {
                this.renderBands(quads, (ISignalMeterDataBands)this.data);
            }
            return quads;
        }
        return super.func_188616_a(state, side, rand);
    }

    public ItemOverrideList func_188617_f() {
        return OVERRIDE_LIST;
    }

    static {
        OVERRIDE_LIST = new ItemOverrideList(Collections.emptyList()){

            public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                if (entity != null && entity.hasCapability(CharsetToolsEngineering.meterTrackerCap, null) && (stack == entity.func_184614_ca() || stack == entity.func_184592_cb())) {
                    Entity rve = Minecraft.func_71410_x().func_175606_aa();
                    if (rve != null && rve != entity && rve.func_70068_e((Entity)entity) > CharsetToolsEngineering.maxRenderDistanceSq) {
                        return originalModel;
                    }
                    return new ModelSignalMeter(((ModelSignalMeter)originalModel).getParent(), ((ISignalMeterTracker)entity.getCapability(CharsetToolsEngineering.meterTrackerCap, null)).getClientData());
                }
                return originalModel;
            }
        };
    }
}

