/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.util.type;

import astavie.thermallogistics.util.StackHandler;
import astavie.thermallogistics.util.type.FluidType;
import astavie.thermallogistics.util.type.ItemType;
import cofh.core.gui.GuiContainerCore;
import cofh.core.network.PacketBase;
import java.util.List;
import java.util.function.Function;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface Type<I> {
    public I getAsStack();

    public I withAmount(int var1);

    public String getDisplayName();

    public String getMissingLocalization(long var1);

    public void writePacket(PacketBase var1);

    public static Function<PacketBase, Type<?>> getReadFunction(int id) {
        if (id == 0) {
            return ItemType::readPacket;
        }
        if (id == 1) {
            return FluidType::readPacket;
        }
        throw new IllegalArgumentException();
    }

    public int getPacketId();

    public NBTTagCompound writeNbt();

    public boolean references(I var1);

    public int normalSize();

    public int maxSize();

    public boolean isNothing();

    public boolean isIdentical(Type<I> var1, boolean var2, boolean var3, boolean var4, boolean var5);

    @SideOnly(value=Side.CLIENT)
    default public List<String> getTooltip(GuiContainerCore gui) {
        return StackHandler.getTooltip(gui, this.getAsStack());
    }

    @SideOnly(value=Side.CLIENT)
    default public void render(GuiContainerCore gui, int x, int y) {
        StackHandler.render(gui, x, y, this.getAsStack(), null);
    }
}

