/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.util.type;

import astavie.thermallogistics.util.type.Type;
import codechicken.lib.fluid.FluidUtils;
import cofh.core.network.PacketBase;
import cofh.core.util.helpers.StringHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class FluidType
implements Type<FluidStack> {
    private final FluidStack compare;

    public FluidType(FluidStack compare) {
        this.compare = compare == null ? null : FluidUtils.copy((FluidStack)compare, (int)1);
    }

    public static FluidType readPacket(PacketBase packet) {
        return new FluidType(packet.getFluidStack());
    }

    public static void writePacket(FluidType type, PacketBase packet) {
        packet.addFluidStack(type.compare);
    }

    public static FluidType readNbt(NBTTagCompound tag) {
        return new FluidType(FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag));
    }

    public static NBTTagCompound writeNbt(FluidType type) {
        return type.compare.writeToNBT(new NBTTagCompound());
    }

    @Override
    public FluidStack getAsStack() {
        return this.compare;
    }

    @Override
    public FluidStack withAmount(int amount) {
        return FluidUtils.copy((FluidStack)this.compare, (int)amount);
    }

    @Override
    public String getDisplayName() {
        return this.compare.getLocalizedName();
    }

    @Override
    public String getMissingLocalization(long amount) {
        return StringHelper.localizeFormat((String)"gui.logistics.terminal.missing.fluid", (Object[])new Object[]{amount, this.getDisplayName()});
    }

    @Override
    public void writePacket(PacketBase packet) {
        FluidType.writePacket(this, packet);
    }

    @Override
    public int getPacketId() {
        return 1;
    }

    @Override
    public NBTTagCompound writeNbt() {
        return FluidType.writeNbt(this);
    }

    @Override
    public boolean references(FluidStack stack) {
        return this.compare.isFluidEqual(stack);
    }

    @Override
    public int maxSize() {
        return 1000;
    }

    @Override
    public boolean isNothing() {
        return this.compare == null;
    }

    @Override
    public boolean isIdentical(Type<FluidStack> other, boolean ignoreMod, boolean ignoreOreDict, boolean ignoreMetadata, boolean ignoreNbt) {
        return this.compare.getFluid() == other.getAsStack().getFluid() && (ignoreNbt || FluidStack.areFluidStackTagsEqual((FluidStack)this.compare, (FluidStack)other.getAsStack()));
    }

    @Override
    public int normalSize() {
        return 1000;
    }

    public boolean equals(Object obj) {
        return obj instanceof FluidType && this.compare.isFluidEqual(((FluidType)obj).compare);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.compare.getFluid()).append((Object)this.compare.tag).build();
    }
}

