/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.util.collection;

import astavie.thermallogistics.util.type.Type;
import cofh.core.network.PacketBase;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.apache.commons.lang3.tuple.Pair;

public abstract class StackList<S> {
    protected final Map<Type<S>, Pair<Long, Boolean>> map = new LinkedHashMap<Type<S>, Pair<Long, Boolean>>();

    public abstract Type<S> getType(S var1);

    public abstract int getAmount(S var1);

    public void add(S stack) {
        this.add(this.getType(stack), this.getAmount(stack));
    }

    public void add(Type<S> type, long amount) {
        if (!type.isNothing() && amount > 0L) {
            this.map.compute(type, (t, p) -> Pair.of((Object)((p == null ? 0L : (Long)p.getLeft()) + amount), (Object)(p == null ? false : (Boolean)p.getRight())));
        }
    }

    public void addAll(StackList<S> list) {
        for (Map.Entry entry : list.map.entrySet()) {
            this.map.compute(entry.getKey(), (t, p) -> Pair.of((Object)((p == null ? 0L : (Long)p.getLeft()) + (Long)((Pair)entry.getValue()).getLeft()), (Object)(p != null && (Boolean)p.getRight() != false || (Boolean)((Pair)entry.getValue()).getRight() != false ? 1 : 0)));
        }
    }

    public void addCraftable(Type<S> type) {
        if (!type.isNothing()) {
            this.map.compute(type, (t, p) -> Pair.of((Object)(p == null ? 0L : (Long)p.getLeft()), (Object)true));
        }
    }

    public long remove(S stack) {
        return this.remove(this.getType(stack), this.getAmount(stack));
    }

    public long remove(Type<S> type, long count) {
        Pair<Long, Boolean> amount = this.map.get(type);
        if (amount == null) {
            return count;
        }
        if (count < (Long)amount.getLeft()) {
            this.map.put(type, (Pair<Long, Boolean>)Pair.of((Object)((Long)amount.getLeft() - count), (Object)((Boolean)amount.getRight())));
            return 0L;
        }
        if (((Boolean)amount.getRight()).booleanValue()) {
            this.map.put(type, (Pair<Long, Boolean>)Pair.of((Object)0L, (Object)true));
        } else {
            this.map.remove(type);
        }
        return (int)(count - (Long)amount.getLeft());
    }

    public long remove(Type<S> type, long count, boolean ignoreMod, boolean ignoreOreDict, boolean ignoreMetadata, boolean ignoreNbt) {
        for (Type<S> compare : this.map.keySet()) {
            if (!type.isIdentical(compare, ignoreMod, ignoreOreDict, ignoreMetadata, ignoreNbt) || (count = this.remove(compare, count)) != 0L) continue;
            return 0L;
        }
        return count;
    }

    public Pair<Type<S>, Long> remove(int index) {
        Iterator<Map.Entry<Type<S>, Pair<Long, Boolean>>> iterator = this.map.entrySet().iterator();
        for (int i = 0; i < index; ++i) {
            iterator.next();
        }
        Map.Entry<Type<S>, Pair<Long, Boolean>> entry = iterator.next();
        iterator.remove();
        return Pair.of(entry.getKey(), (Object)((Long)entry.getValue().getLeft()));
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void clear() {
        this.map.clear();
    }

    public long amount(Type<S> type) {
        return (Long)this.map.getOrDefault(type, (Pair<Long, Boolean>)Pair.of((Object)0L, (Object)false)).getLeft();
    }

    public long amount(S stack) {
        return this.amount((S)this.getType(stack));
    }

    public long amount(Type<S> type, boolean ignoreMod, boolean ignoreOreDict, boolean ignoreMetadata, boolean ignoreNbt) {
        long count = 0L;
        for (Type<S> compare : this.map.keySet()) {
            if (!type.isIdentical(compare, ignoreMod, ignoreOreDict, ignoreMetadata, ignoreNbt)) continue;
            count += this.amount((S)compare);
        }
        return count;
    }

    public boolean craftable(Type<S> type) {
        return (Boolean)this.map.getOrDefault(type, (Pair<Long, Boolean>)Pair.of((Object)0L, (Object)false)).getRight();
    }

    public boolean craftable(S stack) {
        return this.craftable((S)this.getType(stack));
    }

    public Set<Type<S>> types() {
        return Collections.unmodifiableSet(new HashSet<Type<S>>(this.map.keySet()));
    }

    public Iterator<Type<S>> getTypeIterator() {
        return this.map.keySet().iterator();
    }

    public List<S> stacks() {
        return this.map.entrySet().stream().map(e -> ((Type)e.getKey()).withAmount(Math.toIntExact((Long)((Pair)e.getValue()).getLeft()))).collect(Collectors.toList());
    }

    protected void writeType(Type<S> type, PacketBase packet) {
        type.writePacket(packet);
    }

    public abstract Type<S> readType(PacketBase var1);

    protected NBTTagCompound writeType(Type<S> type) {
        return type.writeNbt();
    }

    public abstract Type<S> readType(NBTTagCompound var1);

    public void writePacket(PacketBase packet) {
        packet.addInt(this.map.size());
        for (Map.Entry<Type<S>, Pair<Long, Boolean>> entry : this.map.entrySet()) {
            this.writeType(entry.getKey(), packet);
            packet.addLong(((Long)entry.getValue().getLeft()).longValue());
            packet.addBool(((Boolean)entry.getValue().getRight()).booleanValue());
        }
    }

    public void readPacket(PacketBase packet) {
        this.map.clear();
        int size = packet.getInt();
        for (int i = 0; i < size; ++i) {
            this.map.put(this.readType(packet), (Pair<Long, Boolean>)Pair.of((Object)packet.getLong(), (Object)packet.getBool()));
        }
    }

    public NBTTagList writeNbt() {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<Type<S>, Pair<Long, Boolean>> entry : this.map.entrySet()) {
            NBTTagCompound nbt = this.writeType(entry.getKey());
            nbt.func_74772_a("Count", ((Long)entry.getValue().getLeft()).longValue());
            list.func_74742_a((NBTBase)nbt);
        }
        return list;
    }

    public void readNbt(NBTTagList list) {
        this.map.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            this.map.put(this.readType(tag), (Pair<Long, Boolean>)Pair.of((Object)tag.func_74763_f("Count"), (Object)false));
        }
    }

    public abstract StackList<S> copy();
}

