/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.util;

import astavie.thermallogistics.ThermalLogistics;
import astavie.thermallogistics.attachment.ICrafter;
import astavie.thermallogistics.attachment.ICrafterContainer;
import astavie.thermallogistics.attachment.IRequester;
import astavie.thermallogistics.attachment.IRequesterContainer;
import astavie.thermallogistics.client.gui.GuiCrafter;
import astavie.thermallogistics.client.gui.element.ElementSlotFluid;
import astavie.thermallogistics.client.gui.element.ElementSlotItem;
import astavie.thermallogistics.process.IProcessRequester;
import astavie.thermallogistics.util.RequesterReference;
import astavie.thermallogistics.util.collection.StackList;
import astavie.thermallogistics.util.type.Type;
import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.ElementBase;
import cofh.core.network.PacketBase;
import cofh.core.util.helpers.InventoryHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermaldynamics.duct.item.DuctUnitItem;
import cofh.thermaldynamics.duct.item.GridItem;
import cofh.thermaldynamics.duct.item.SimulatedInv;
import cofh.thermaldynamics.duct.item.StackMap;
import gnu.trove.iterator.TObjectIntIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public class StackHandler {
    public static boolean SIM = false;

    @SideOnly(value=Side.CLIENT)
    public static void render(GuiContainerCore gui, int x, int y, Object item, boolean count) {
        if (item instanceof ItemStack) {
            ItemStack stack = (ItemStack)item;
            FontRenderer font = null;
            if (!stack.func_190926_b()) {
                font = stack.func_77973_b().getFontRenderer(stack);
            }
            if (font == null) {
                font = gui.getFontRenderer();
            }
            RenderHelper.enableGUIStandardItemLighting();
            gui.field_146296_j.func_180450_b(stack, x, y);
            gui.field_146296_j.func_180453_a(font, stack, x, y - (gui.field_147012_x.func_190926_b() ? 0 : 8), count ? null : "");
        } else if (item instanceof FluidStack) {
            FluidStack fluid = (FluidStack)item;
            if (count) {
                String amount = StringHelper.formatNumber((long)fluid.amount);
                StackHandler.render(gui, x, y, item, amount);
            } else {
                GlStateManager.func_179140_f();
                gui.drawFluid(x, y, fluid, 16, 16);
            }
        } else {
            throw new IllegalArgumentException("Unknown item type " + item.getClass().getName());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void render(GuiContainerCore gui, int x, int y, Object item, String text) {
        if (item instanceof ItemStack) {
            RenderHelper.enableGUIStandardItemLighting();
            gui.drawItemStack((ItemStack)item, x, y, true, "");
        } else if (item instanceof FluidStack) {
            GlStateManager.func_179140_f();
            gui.drawFluid(x, y, (FluidStack)item, 16, 16);
        } else {
            throw new IllegalArgumentException("Unknown item type " + item.getClass().getName());
        }
        if (text != null) {
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179084_k();
            if (ThermalLogistics.INSTANCE.smallText) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
                gui.getFontRenderer().func_175063_a(text, (float)((x + 16) * 2 - gui.getFontRenderer().func_78256_a(text)), (float)((y + 12) * 2), 0xFFFFFF);
                GlStateManager.func_179121_F();
            } else {
                gui.getFontRenderer().func_175063_a(text, (float)(x + 17 - gui.getFontRenderer().func_78256_a(text)), (float)(y + 9), 0xFFFFFF);
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static List<String> getTooltip(GuiContainerCore gui, Object item) {
        if (item instanceof ItemStack) {
            return gui.func_191927_a((ItemStack)item);
        }
        if (item instanceof FluidStack) {
            return Collections.singletonList(((FluidStack)item).getLocalizedName());
        }
        throw new IllegalArgumentException("Unknown item type " + item.getClass().getName());
    }

    public static <I> void addRequesters(Collection<IRequester<I>> collection, Object object) {
        if (object instanceof IRequester) {
            collection.add((IRequester)object);
        } else if (object instanceof IRequesterContainer) {
            for (IRequester requester : ((IRequesterContainer)object).getRequesters()) {
                StackHandler.addRequesters(collection, requester);
            }
        }
    }

    public static <I> void addCrafters(Collection<ICrafter<I>> collection, Object object) {
        if (object instanceof ICrafter) {
            if (((ICrafter)object).isEnabled()) {
                collection.add((ICrafter)object);
            }
        } else if (object instanceof ICrafterContainer) {
            for (ICrafter crafter : ((ICrafterContainer)object).getCrafters()) {
                StackHandler.addCrafters(collection, crafter);
            }
        }
    }

    public static <I> boolean forEachCrafter(Object object, Predicate<ICrafter<I>> function) {
        if (object instanceof ICrafter) {
            if (((ICrafter)object).isEnabled()) {
                return function.test((ICrafter)object);
            }
        } else if (object instanceof ICrafterContainer) {
            for (ICrafter crafter : ((ICrafterContainer)object).getCrafters()) {
                if (!StackHandler.forEachCrafter(crafter, function)) continue;
                return true;
            }
        }
        return false;
    }

    public static <I> void addCraftable(StackList<I> list, Object object) {
        block4: {
            block3: {
                if (!(object instanceof ICrafter)) break block3;
                if (!((ICrafter)object).isEnabled()) break block4;
                for (Type type : ((ICrafter)object).getOutputs().types()) {
                    list.addCraftable(type);
                }
                break block4;
            }
            if (object instanceof ICrafterContainer) {
                for (ICrafter crafter : ((ICrafterContainer)object).getCrafters()) {
                    StackHandler.addCraftable(list, crafter);
                }
            }
        }
    }

    public static <I> NBTTagList writeRequestMap(Map<RequesterReference<I>, StackList<I>> map) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<RequesterReference<I>, StackList<I>> entry : map.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a("reference", (NBTBase)RequesterReference.writeNBT(entry.getKey()));
            tag.func_74782_a("stacks", (NBTBase)entry.getValue().writeNbt());
            list.func_74742_a((NBTBase)tag);
        }
        return list;
    }

    public static <I> Map<RequesterReference<I>, StackList<I>> readRequestMap(NBTTagList list, Supplier<StackList<I>> supplier) {
        LinkedHashMap<RequesterReference<I>, StackList<I>> request = new LinkedHashMap<RequesterReference<I>, StackList<I>>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            StackList<I> stackList = supplier.get();
            stackList.readNbt(tag.func_150295_c("stacks", 10));
            request.put(RequesterReference.readNBT(tag.func_74775_l("reference")), stackList);
        }
        return request;
    }

    public static <I> void writeRequestMap(Map<RequesterReference<I>, StackList<I>> map, PacketBase packet) {
        packet.addInt(map.size());
        for (Map.Entry<RequesterReference<I>, StackList<I>> entry : map.entrySet()) {
            RequesterReference.writePacket(packet, entry.getKey());
            entry.getValue().writePacket(packet);
        }
    }

    public static <I> Map<RequesterReference<I>, StackList<I>> readRequestMap(PacketBase packet, Supplier<StackList<I>> supplier) {
        LinkedHashMap<RequesterReference<I>, StackList<I>> request = new LinkedHashMap<RequesterReference<I>, StackList<I>>();
        int size = packet.getInt();
        for (int i = 0; i < size; ++i) {
            RequesterReference reference = RequesterReference.readPacket(packet);
            StackList<I> list = supplier.get();
            list.readPacket(packet);
            if (list.isEmpty()) continue;
            request.put(reference, list);
        }
        return request;
    }

    public static String getScaledNumber(long number) {
        if (ThermalLogistics.INSTANCE.smallText) {
            return StringHelper.getScaledNumber((long)number);
        }
        if (number >= 1000000000L) {
            return number / 1000000000L + "G";
        }
        if (number >= 1000000L) {
            return number / 1000000L + "M";
        }
        if (number >= 1000L) {
            return number / 1000L + "k";
        }
        return String.valueOf(number);
    }

    public static int canRouteItem(DuctUnitItem duct, ItemStack stack, byte side, @Nullable IProcessRequester<ItemStack> requester) {
        if (duct.getGrid() == null) {
            return stack.func_190916_E();
        }
        int stackSizeLeft = stack.func_190916_E();
        ItemStack curItem = stack.func_77946_l();
        curItem.func_190920_e(Math.min(duct.getMoveStackSize(side), curItem.func_190916_E()));
        if (curItem.func_190916_E() > 0) {
            stackSizeLeft = StackHandler.simTransferI(duct, side, curItem.func_77946_l(), requester);
            stackSizeLeft = stack.func_190916_E() - curItem.func_190916_E() + stackSizeLeft;
        }
        return stackSizeLeft;
    }

    private static int simTransferI(DuctUnitItem duct, byte side, ItemStack stack, @Nullable IProcessRequester<ItemStack> requester) {
        SIM = true;
        ItemStack itemStack = StackHandler.simTransfer(duct, side, stack, requester);
        SIM = false;
        return itemStack.func_190926_b() ? 0 : itemStack.func_190916_E();
    }

    private static ItemStack simTransfer(DuctUnitItem duct, byte side, ItemStack stack, @Nullable IProcessRequester<ItemStack> requester) {
        EnumFacing face = EnumFacing.field_82609_l[side];
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        DuctUnitItem.Cache cache = ((DuctUnitItem.Cache[])duct.tileCache)[side];
        if (duct.getGrid() == null || cache == null) {
            return stack;
        }
        boolean routeItems = cache.filter.shouldIncRouteItems();
        int maxStock = cache.filter.getMaxStock();
        IItemHandler itemHandler = cache.getItemHandler(side ^ 1);
        if (!routeItems) {
            return DuctUnitItem.simulateInsertItemStackIntoInventory((IItemHandler)itemHandler, (ItemStack)stack, (int)(side ^ 1), (int)maxStock);
        }
        StackMap travelingItems = new StackMap();
        StackMap map = (StackMap)((GridItem)duct.getGrid()).travelingItems.get(duct.pos().func_177972_a(face));
        if (map != null) {
            for (ItemStack itemStack : map.getItems()) {
                travelingItems.addItemstack(itemStack, (int)side);
            }
        }
        if (requester != null) {
            for (StackList<ItemStack> stackList : requester.getRequests().values()) {
                for (Type<ItemStack> type : stackList.types()) {
                    int remove;
                    for (long amount = stackList.amount((ItemStack)type); amount > 0L; amount -= (long)remove) {
                        remove = (int)Math.min(amount, (long)type.maxSize());
                        travelingItems.addItemstack(type.withAmount(remove), (int)side);
                    }
                }
            }
        }
        if (travelingItems == null || travelingItems.isEmpty()) {
            return DuctUnitItem.simulateInsertItemStackIntoInventory((IItemHandler)itemHandler, (ItemStack)stack, (int)(side ^ 1), (int)maxStock);
        }
        if (travelingItems.size() == 1) {
            if (ItemHelper.itemsIdentical((ItemStack)stack, (ItemStack)travelingItems.getItems().next())) {
                stack.func_190917_f(travelingItems.getItems().next().func_190916_E());
                return DuctUnitItem.simulateInsertItemStackIntoInventory((IItemHandler)itemHandler, (ItemStack)stack, (int)(side ^ 1), (int)maxStock);
            }
        } else {
            int s = 0;
            for (ItemStack travelingItem : travelingItems.getItems()) {
                if (!ItemHelper.itemsIdentical((ItemStack)stack, (ItemStack)travelingItem)) {
                    s = -1;
                    break;
                }
                s += travelingItem.func_190916_E();
            }
            if (s >= 0) {
                stack.func_190917_f(s);
                return DuctUnitItem.simulateInsertItemStackIntoInventory((IItemHandler)itemHandler, (ItemStack)stack, (int)(side ^ 1), (int)maxStock);
            }
        }
        SimulatedInv simulatedInv = SimulatedInv.wrapHandler((IItemHandler)itemHandler);
        TObjectIntIterator tObjectIntIterator = travelingItems.iterator();
        while (tObjectIntIterator.hasNext()) {
            tObjectIntIterator.advance();
            StackMap.ItemEntry itemEntry = (StackMap.ItemEntry)tObjectIntIterator.key();
            if (itemEntry.side != side && cache.areEquivalentHandlers(itemHandler, itemEntry.side) || InventoryHelper.insertStackIntoInventory((IItemHandler)simulatedInv, (ItemStack)itemEntry.toItemStack(tObjectIntIterator.value()), (boolean)false).func_190926_b() || !ItemHelper.itemsIdentical((ItemStack)stack, (ItemStack)itemEntry.toItemStack(tObjectIntIterator.value()))) continue;
            return stack;
        }
        return DuctUnitItem.simulateInsertItemStackIntoInventory((IItemHandler)simulatedInv, (ItemStack)stack, (int)(side ^ 1), (int)maxStock);
    }

    public static void writePacket(PacketBase packet, Object item, Class<?> c, boolean identifier) {
        if (c == ItemStack.class) {
            if (identifier) {
                packet.addByte(0);
            }
            packet.addItemStack((ItemStack)item);
        } else if (c == FluidStack.class) {
            if (identifier) {
                packet.addByte(1);
            }
            packet.addFluidStack((FluidStack)item);
        } else {
            throw new IllegalArgumentException("Unknown item type " + c.getName());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static ElementBase getSlot(GuiCrafter gui, int x, int y, GuiCrafter.Slot<?> slot) {
        Class<?> c = slot.getCrafter().getItemClass();
        if (c == ItemStack.class) {
            return new ElementSlotItem(gui, x, y, slot, slot, true);
        }
        if (c == FluidStack.class) {
            return new ElementSlotFluid(gui, x, y, slot, slot, true);
        }
        throw new IllegalArgumentException("Unknown item type " + c.getName());
    }
}

