/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.util;

import astavie.thermallogistics.attachment.IRequester;
import astavie.thermallogistics.attachment.IRequesterContainer;
import cofh.core.network.PacketBase;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class RequesterReference<I> {
    public final int dim;
    public final BlockPos pos;
    public final byte side;
    public final int index;
    private long tick;
    private IRequester<I> cache;
    private ItemStack icon = ItemStack.field_190927_a;
    private ItemStack tile = ItemStack.field_190927_a;

    public RequesterReference(int dim, BlockPos pos) {
        this(dim, pos, 0, 0);
    }

    public RequesterReference(int dim, BlockPos pos, byte side) {
        this(dim, pos, side, 0);
    }

    public RequesterReference(int dim, BlockPos pos, byte side, int index) {
        this.dim = dim;
        this.pos = pos;
        this.side = side;
        this.index = index;
    }

    public static NBTTagCompound writeNBT(RequesterReference<?> reference) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (reference == null) {
            return nbt;
        }
        nbt.func_74768_a("dim", reference.dim);
        nbt.func_74768_a("x", reference.pos.func_177958_n());
        nbt.func_74768_a("y", reference.pos.func_177956_o());
        nbt.func_74768_a("z", reference.pos.func_177952_p());
        nbt.func_74774_a("side", reference.side);
        nbt.func_74768_a("index", reference.index);
        return nbt;
    }

    public static <I> RequesterReference<I> readNBT(NBTTagCompound nbt) {
        if (nbt.func_82582_d()) {
            return null;
        }
        return new RequesterReference<I>(nbt.func_74762_e("dim"), new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z")), nbt.func_74771_c("side"), nbt.func_74762_e("index"));
    }

    public static void writePacket(PacketBase packet, RequesterReference<?> reference) {
        packet.addBool(reference == null);
        if (reference != null) {
            packet.addInt(reference.dim);
            packet.addCoords(reference.pos.func_177958_n(), reference.pos.func_177956_o(), reference.pos.func_177952_p());
            packet.addByte(reference.side);
            packet.addInt(reference.index);
            IRequester<?> requester = reference.get();
            packet.addItemStack(requester.getIcon());
            packet.addItemStack(requester.getTileIcon());
        }
    }

    public static <I> RequesterReference<I> readPacket(PacketBase packet) {
        if (packet.getBool()) {
            return null;
        }
        RequesterReference<I> reference = new RequesterReference<I>(packet.getInt(), packet.getCoords(), packet.getByte(), packet.getInt());
        reference.icon = packet.getItemStack();
        reference.tile = packet.getItemStack();
        return reference;
    }

    public boolean isLoaded() {
        WorldServer world = DimensionManager.getWorld((int)this.dim);
        return world != null && world.func_175667_e(this.pos);
    }

    public boolean isLoaded(World world) {
        return world.field_73011_w.getDimension() == this.dim && world.func_175667_e(this.pos);
    }

    public IRequester<I> get() {
        return this.get((World)FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.dim));
    }

    public IRequesterContainer<I> getContainer() {
        return this.getContainer((World)FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.dim));
    }

    public IRequester<I> get(World world) {
        if (world.field_73011_w.getDimension() != this.dim) {
            return null;
        }
        if (world.func_82737_E() == this.tick) {
            return this.cache;
        }
        this.tick = world.func_82737_E();
        this.cache = null;
        TileEntity tile = world.func_175625_s(this.pos);
        try {
            if (tile instanceof IRequester) {
                this.cache = (IRequester)tile;
            } else if (tile instanceof IRequesterContainer) {
                List list = ((IRequesterContainer)tile).getRequesters();
                this.cache = this.index < list.size() ? list.get(this.index) : null;
            } else if (tile instanceof TileGrid) {
                Attachment attachment = ((TileGrid)tile).getAttachment((int)this.side);
                if (attachment instanceof IRequester) {
                    this.cache = (IRequester)attachment;
                } else if (attachment instanceof IRequesterContainer) {
                    List list = ((IRequesterContainer)attachment).getRequesters();
                    this.cache = this.index < list.size() ? list.get(this.index) : null;
                }
            }
        }
        catch (ClassCastException ignore) {
            this.cache = null;
        }
        return this.cache;
    }

    public IRequesterContainer<I> getContainer(World world) {
        if (world.field_73011_w.getDimension() != this.dim) {
            return null;
        }
        TileEntity tile = world.func_175625_s(this.pos);
        try {
            Attachment attachment;
            if (tile instanceof IRequesterContainer) {
                return (IRequesterContainer)tile;
            }
            if (tile instanceof TileGrid && (attachment = ((TileGrid)tile).getAttachment((int)this.side)) instanceof IRequesterContainer) {
                return (IRequesterContainer)attachment;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    public boolean references(IRequester<?> requester) {
        return requester != null && requester.referencedBy(this);
    }

    public boolean equals(Object object) {
        if (object instanceof RequesterReference) {
            RequesterReference reference = (RequesterReference)object;
            return reference.dim == this.dim && reference.pos.equals((Object)this.pos) && reference.side == this.side && reference.index == this.index;
        }
        return false;
    }

    public int hashCode() {
        return ((Integer.hashCode(this.dim) * 31 + this.pos.hashCode()) * 31 + Integer.hashCode(this.side)) * 31 + Integer.hashCode(this.index);
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public ItemStack getTileIcon() {
        return this.tile;
    }
}

